/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.commands.CommandExecuter;
import net.aufdemrand.denizen.scripts.requirements.RequirementChecker;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEngine {
    private final Denizen denizen;
    private final ScriptHelper scriptHelper;
    private final ScriptBuilder scriptBuilder;
    private final RequirementChecker requirementChecker;
    private final CommandExecuter commandExecuter;
    private Map<Player, List<ScriptEntry>> playerQueue = new ConcurrentHashMap<Player, List<ScriptEntry>>();
    private Map<Player, List<ScriptEntry>> playerTaskQueue = new ConcurrentHashMap<Player, List<ScriptEntry>>();
    private Map<DenizenNPC, List<ScriptEntry>> npcQueue = new ConcurrentHashMap<DenizenNPC, List<ScriptEntry>>();

    public ScriptEngine(Denizen denizenPlugin) {
        this.denizen = denizenPlugin;
        this.scriptHelper = new ScriptHelper(this.denizen);
        this.scriptBuilder = new ScriptBuilder(this.denizen);
        this.commandExecuter = new CommandExecuter(this.denizen);
        this.requirementChecker = new RequirementChecker(this.denizen);
    }

    public ScriptHelper getScriptHelper() {
        return this.scriptHelper;
    }

    public RequirementChecker getRequirementChecker() {
        return this.requirementChecker;
    }

    public ScriptBuilder getScriptBuilder() {
        return this.scriptBuilder;
    }

    public CommandExecuter getScriptExecuter() {
        return this.commandExecuter;
    }

    public void run() {
        ScriptEntry scriptEntry;
        boolean instantly;
        if (!this.playerQueue.isEmpty()) {
            for (Map.Entry<Player, List<ScriptEntry>> entry : this.playerQueue.entrySet()) {
                if (entry.getValue().isEmpty() || entry.getValue().get(0).getAllowedRunTime() >= System.currentTimeMillis()) continue;
                do {
                    instantly = false;
                    scriptEntry = entry.getValue().get(0);
                    scriptEntry.setSendingQueue(QueueType.PLAYER);
                    if (entry.getValue().size() > 1 && entry.getValue().get(0).isInstant()) {
                        instantly = true;
                    }
                    entry.getValue().remove(0);
                    this.playerQueue.put(entry.getKey(), entry.getValue());
                    try {
                        this.getScriptExecuter().execute(scriptEntry);
                    }
                    catch (Throwable e) {
                        dB.echoError("Woah! An exception has been called with this command!");
                        if (!dB.showStackTraces) {
                            dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                            continue;
                        }
                        e.printStackTrace();
                    }
                } while (instantly);
            }
        }
        if (!this.playerTaskQueue.isEmpty()) {
            for (Map.Entry<Player, List<ScriptEntry>> entry : this.playerTaskQueue.entrySet()) {
                if (entry.getValue().isEmpty() || entry.getValue().get(0).getAllowedRunTime() >= System.currentTimeMillis()) continue;
                do {
                    instantly = false;
                    scriptEntry = entry.getValue().get(0);
                    scriptEntry.setSendingQueue(QueueType.PLAYER_TASK);
                    if (entry.getValue().size() > 1 && entry.getValue().get(0).isInstant()) {
                        instantly = true;
                    }
                    entry.getValue().remove(0);
                    this.playerTaskQueue.put(entry.getKey(), entry.getValue());
                    try {
                        this.getScriptExecuter().execute(scriptEntry);
                    }
                    catch (Throwable e) {
                        dB.echoError("Woah! An exception has been called with this command!");
                        if (!dB.showStackTraces) {
                            dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                            continue;
                        }
                        e.printStackTrace();
                    }
                } while (instantly);
            }
        }
        if (!this.npcQueue.isEmpty()) {
            for (Map.Entry<Object, List<ScriptEntry>> entry : this.npcQueue.entrySet()) {
                if (entry.getValue().isEmpty() || entry.getValue().get(0).getAllowedRunTime() >= System.currentTimeMillis()) continue;
                do {
                    instantly = false;
                    scriptEntry = entry.getValue().get(0);
                    scriptEntry.setSendingQueue(QueueType.NPC);
                    if (entry.getValue().size() > 1 && entry.getValue().get(0).isInstant()) {
                        instantly = true;
                    }
                    entry.getValue().remove(0);
                    this.npcQueue.put((DenizenNPC)entry.getKey(), entry.getValue());
                    try {
                        this.getScriptExecuter().execute(scriptEntry);
                    }
                    catch (Throwable e) {
                        dB.echoError("Woah! An exception has been called with this command!");
                        if (!dB.showStackTraces) {
                            dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                            continue;
                        }
                        e.printStackTrace();
                    }
                } while (instantly);
            }
        }
    }

    public void addToQue(Player player, List<ScriptEntry> scriptEntries, QueueType queueType) {
        switch (queueType) {
            case PLAYER: {
                List<ScriptEntry> scriptCommandList = this.playerQueue.get(player);
                if (scriptCommandList == null) {
                    scriptCommandList = new ArrayList<ScriptEntry>();
                }
                this.playerQueue.remove(player);
                scriptCommandList.addAll(scriptEntries);
                this.playerQueue.put(player, scriptCommandList);
                break;
            }
            case PLAYER_TASK: {
                List<ScriptEntry> scriptCommandList = this.playerTaskQueue.get(player);
                if (scriptCommandList == null) {
                    scriptCommandList = new ArrayList<ScriptEntry>();
                }
                this.playerTaskQueue.remove(player);
                scriptCommandList.addAll(scriptEntries);
                this.playerTaskQueue.put(player, scriptCommandList);
            }
        }
    }

    public void addToQue(DenizenNPC npc, List<ScriptEntry> scriptEntries, QueueType queueType) {
        switch (queueType) {
            case NPC: {
                List<ScriptEntry> scriptCommandList = this.npcQueue.get(npc);
                if (scriptCommandList == null) {
                    scriptCommandList = new ArrayList<ScriptEntry>();
                }
                this.npcQueue.remove(npc);
                scriptCommandList.addAll(scriptEntries);
                this.npcQueue.put(npc, scriptCommandList);
            }
        }
    }

    public Map<Player, List<ScriptEntry>> getQueue(QueueType queueType) {
        switch (queueType) {
            case PLAYER: {
                return this.playerQueue;
            }
            case PLAYER_TASK: {
                return this.playerTaskQueue;
            }
        }
        return null;
    }

    public Map<DenizenNPC, List<ScriptEntry>> getDQueue(QueueType queueType) {
        switch (queueType) {
            case NPC: {
                return this.npcQueue;
            }
        }
        return null;
    }

    public List<ScriptEntry> getPlayerQueue(Player player, QueueType queueType) {
        return this.getQueue(queueType).get(player);
    }

    public List<ScriptEntry> getDenizenQueue(DenizenNPC npc, QueueType queueType) {
        return this.getDQueue(queueType).get(npc);
    }

    public boolean injectToQueue(Player player, List<ScriptEntry> scriptEntries, QueueType queueType, int position) {
        List<Object> scriptCommandList = new ArrayList();
        switch (queueType) {
            case PLAYER: {
                scriptCommandList = this.playerQueue.get(player);
                this.playerQueue.remove(player);
                if (position > scriptCommandList.size() || position < 0) {
                    position = 1;
                }
                if (scriptCommandList.size() == 0) {
                    position = 0;
                }
                scriptCommandList.addAll(position, scriptEntries);
                this.playerQueue.put(player, scriptCommandList);
                return true;
            }
            case PLAYER_TASK: {
                scriptCommandList = this.playerTaskQueue.get(player);
                this.playerTaskQueue.remove(player);
                if (position > scriptCommandList.size() || position < 0) {
                    position = 1;
                }
                if (scriptCommandList.size() == 0) {
                    position = 0;
                }
                scriptCommandList.addAll(position, scriptEntries);
                this.playerTaskQueue.put(player, scriptCommandList);
                return true;
            }
        }
        return false;
    }

    public boolean injectToQueue(Player player, ScriptEntry scriptEntry, QueueType queueType, int position) {
        ArrayList<ScriptEntry> scriptEntries = new ArrayList<ScriptEntry>();
        scriptEntries.add(scriptEntry);
        return this.injectToQueue(player, scriptEntries, queueType, position);
    }

    public boolean injectToQueue(DenizenNPC npc, List<ScriptEntry> scriptEntries, QueueType queueType, int position) {
        List<Object> scriptCommandList = new ArrayList();
        switch (queueType) {
            case NPC: {
                scriptCommandList = this.npcQueue.get(npc);
                this.playerQueue.remove(npc);
                if (position > scriptCommandList.size() || position < 0) {
                    position = 1;
                }
                if (scriptCommandList.size() == 0) {
                    position = 0;
                }
                scriptCommandList.addAll(position, scriptEntries);
                this.npcQueue.put(npc, scriptCommandList);
                return true;
            }
        }
        return false;
    }

    public boolean injectToQue(DenizenNPC npc, ScriptEntry scriptEntry, QueueType queueType, int position) {
        ArrayList<ScriptEntry> scriptEntries = new ArrayList<ScriptEntry>();
        scriptEntries.add(scriptEntry);
        return this.injectToQueue(npc, scriptEntries, queueType, position);
    }

    public void replaceQueue(Player player, List<ScriptEntry> scriptEntries, QueueType queueType) {
        switch (queueType) {
            case PLAYER: {
                this.playerQueue.remove(player);
                this.playerQueue.put(player, scriptEntries);
                break;
            }
            case PLAYER_TASK: {
                this.playerTaskQueue.remove(player);
                this.playerTaskQueue.put(player, scriptEntries);
                break;
            }
        }
    }

    public void replaceQueue(DenizenNPC npc, List<ScriptEntry> scriptEntries, QueueType queueType) {
        switch (queueType) {
            case NPC: {
                this.npcQueue.remove(npc);
                this.npcQueue.put(npc, scriptEntries);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueueType {
        PLAYER,
        PLAYER_TASK,
        NPC;

    }
}

