/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class DropCommand
extends AbstractCommand {
    ItemStack item;
    Location location;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.item = null;
        Integer qty = null;
        this.location = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesItem(arg)) {
                this.item = aH.getItemFrom(arg);
                dB.echoDebug("...set ITEM: '%s'", aH.getStringFrom(arg));
                continue;
            }
            if (aH.matchesQuantity(arg)) {
                qty = aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_QUANTITY, String.valueOf(qty));
                continue;
            }
            if (!aH.matchesLocation(arg)) continue;
            this.location = aH.getLocationFrom(arg);
            dB.echoDebug(dB.Messages.DEBUG_SET_LOCATION, aH.getStringFrom(arg));
        }
        if (this.item == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_INVALID_ITEM);
        }
        if (this.location == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_LOCATION);
        }
        if (qty != null) {
            this.item.setAmount(qty.intValue());
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        this.location.getWorld().dropItemNaturally(this.location, this.item);
    }
}

