/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;

public class BreakCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<ScriptEngine.QueueType> queues = new ArrayList<ScriptEngine.QueueType>();
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesQueueType(arg)) {
                queues.add(aH.getQueueFrom(arg));
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (queues.isEmpty()) {
            throw new InvalidArgumentsException("Must specify at least one queueType!");
        }
        scriptEntry.addObject("queuetype", queues);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List queues = (List)scriptEntry.getObject("queues");
        dB.echoApproval(ChatColor.DARK_GRAY + "Executing '" + ChatColor.YELLOW + this.getName() + ChatColor.DARK_GRAY + "': " + "Queues=" + ChatColor.YELLOW + queues.toString() + ChatColor.DARK_GRAY + "'" + (scriptEntry.getPlayer() != null ? ", PLAYER='" + ChatColor.YELLOW + scriptEntry.getPlayer().getName() + ChatColor.DARK_GRAY + "'" : "") + (scriptEntry.getNPC() != null ? ", NPC='" + ChatColor.YELLOW + scriptEntry.getNPC().getName() + "/" + scriptEntry.getNPC().getId() + ChatColor.DARK_GRAY + "'" : ""));
        ArrayList<ScriptEntry> emptyList = new ArrayList<ScriptEntry>();
        for (ScriptEngine.QueueType queue : queues) {
            if (queue == ScriptEngine.QueueType.PLAYER) {
                this.denizen.getScriptEngine().replaceQueue(scriptEntry.getPlayer(), emptyList, ScriptEngine.QueueType.PLAYER);
                continue;
            }
            if (queue == ScriptEngine.QueueType.PLAYER_TASK) {
                this.denizen.getScriptEngine().replaceQueue(scriptEntry.getPlayer(), emptyList, ScriptEngine.QueueType.PLAYER_TASK);
                continue;
            }
            if (queue != ScriptEngine.QueueType.NPC) continue;
            this.denizen.getScriptEngine().replaceQueue(scriptEntry.getNPC(), emptyList, ScriptEngine.QueueType.NPC);
        }
    }
}

