/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.commands.core.EngageCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptBuilder {
    Denizen plugin;
    Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");

    public ScriptBuilder(Denizen denizenPlugin) {
        this.plugin = denizenPlugin;
    }

    public String[] buildArgs(String stringArgs) {
        return this.buildArgs(null, null, stringArgs);
    }

    public String[] buildArgs(Player player, DenizenNPC npc, String stringArgs) {
        return this.buildArgs(player, npc, stringArgs, true);
    }

    public String[] buildArgs(Player player, DenizenNPC npc, String stringArgs, boolean verbose) {
        if (stringArgs == null) {
            return null;
        }
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher regexMatcher = this.regex.matcher(stringArgs);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(this.plugin.tagManager().tag(player, npc, regexMatcher.group(1), true));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(this.plugin.tagManager().tag(player, npc, regexMatcher.group(2), true));
                continue;
            }
            matchList.add(this.plugin.tagManager().tag(player, npc, regexMatcher.group(), true));
        }
        if (verbose) {
            dB.echoDebug(ChatColor.GRAY + "Args: " + Arrays.toString(matchList.toArray()));
        }
        String[] split = new String[matchList.size()];
        matchList.toArray(split);
        return split;
    }

    public List<ScriptEntry> addObjectToEntries(List<ScriptEntry> scriptEntryList, String key, Object obj) {
        for (ScriptEntry entry : scriptEntryList) {
            entry.addObject(key, obj);
        }
        return scriptEntryList;
    }

    public List<ScriptEntry> buildScriptEntries(DenizenNPC npc, List<String> script, String scriptName) {
        return this.buildScriptEntries(null, npc, script, scriptName, null, null, null);
    }

    public List<ScriptEntry> buildScriptEntries(Player player, List<String> script, String scriptName) {
        return this.buildScriptEntries(player, null, script, scriptName, null, null, null);
    }

    public List<ScriptEntry> buildScriptEntries(Player player, DenizenNPC npc, List<String> script, String scriptName, String step) {
        return this.buildScriptEntries(player, npc, script, scriptName, step, null, null);
    }

    public List<ScriptEntry> buildScriptEntries(Player player, DenizenNPC npc, List<String> script, String scriptName, String step, String playerText, String formattedText) {
        ArrayList<ScriptEntry> scriptCommands = new ArrayList<ScriptEntry>();
        if (script == null || script.isEmpty()) {
            dB.echoError("Building script entries... no entries to build!");
            return null;
        }
        dB.echoDebug("Building script entries:");
        for (String thisItem : script) {
            if (thisItem.toUpperCase().contains("ENGAGE") && thisItem.toUpperCase().contains("NOW")) {
                this.plugin.getCommandRegistry().get(EngageCommand.class).setEngaged(npc.getCitizen(), true);
            }
            String[] scriptEntry = new String[2];
            if (thisItem.split(" ", 2).length == 1) {
                scriptEntry[0] = thisItem;
                scriptEntry[1] = null;
            } else {
                scriptEntry = thisItem.split(" ", 2);
            }
            try {
                Object[] args = this.buildArgs(player, npc, scriptEntry[1], false);
                dB.echoDebug("Adding '" + scriptEntry[0] + "'  Args: " + Arrays.toString(args));
                scriptCommands.add(new ScriptEntry(scriptEntry[0], (String[])args, player, npc, scriptName, step, playerText, formattedText));
            }
            catch (Exception e) {
                if (!dB.showStackTraces) continue;
                e.printStackTrace();
            }
        }
        return scriptCommands;
    }

    public void queueScriptEntries(Player player, List<ScriptEntry> scriptEntries, ScriptEngine.QueueType queueType) {
        if (scriptEntries == null || scriptEntries.isEmpty()) {
            dB.echoError("Queueing up script... no entries to queue!");
            dB.echoDebug(dB.DebugElement.Footer);
            return;
        }
        Map<Player, List<ScriptEntry>> thisQueue = this.plugin.getScriptEngine().getQueue(queueType);
        ArrayList<ScriptEntry> existingScriptEntries = new ArrayList<ScriptEntry>();
        if (thisQueue.containsKey(player)) {
            existingScriptEntries.addAll((Collection)thisQueue.get(player));
            thisQueue.remove(player);
        }
        existingScriptEntries.addAll(scriptEntries);
        thisQueue.put(player, existingScriptEntries);
        dB.echoApproval("Queueing up script... entries added!");
        dB.echoDebug(dB.DebugElement.Footer);
    }

    public void queueScriptEntries(DenizenNPC npc, List<ScriptEntry> scriptEntries, ScriptEngine.QueueType queueType) {
        if (scriptEntries == null || scriptEntries.isEmpty()) {
            dB.echoError("Queueing up script... no entries to queue!");
            dB.echoDebug(dB.DebugElement.Footer);
            return;
        }
        Map<DenizenNPC, List<ScriptEntry>> thisQueue = this.plugin.getScriptEngine().getDQueue(queueType);
        ArrayList<ScriptEntry> existingScriptEntries = new ArrayList<ScriptEntry>();
        if (thisQueue.containsKey(npc)) {
            existingScriptEntries.addAll((Collection)thisQueue.get(npc));
            thisQueue.remove(npc);
        }
        existingScriptEntries.addAll(scriptEntries);
        thisQueue.put(npc, existingScriptEntries);
        dB.echoApproval("Queueing up script... entries added!");
        dB.echoDebug(dB.DebugElement.Footer);
    }

    public boolean runTaskScript(Player player, String scriptName) {
        if (!aH.matchesScript("script:" + scriptName)) {
            return false;
        }
        try {
            List<String> theScript = this.plugin.getScriptEngine().getScriptHelper().getScriptContents(scriptName + ".SCRIPT");
            this.queueScriptEntries(player, this.buildScriptEntries(player, theScript, scriptName), ScriptEngine.QueueType.PLAYER_TASK);
        }
        catch (Exception e) {
            if (dB.showStackTraces) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean runTaskScript(Player player, DenizenNPC npc, String scriptName) {
        if (!aH.matchesScript("script:" + scriptName)) {
            return false;
        }
        try {
            List<String> theScript = this.plugin.getScriptEngine().getScriptHelper().getScriptContents(scriptName + ".SCRIPT");
            this.queueScriptEntries(player, this.buildScriptEntries(player, npc, theScript, scriptName, null), ScriptEngine.QueueType.PLAYER_TASK);
        }
        catch (Exception e) {
            if (dB.showStackTraces) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean runTaskScript(DenizenNPC npc, String scriptName) {
        if (!aH.matchesScript("script:" + scriptName)) {
            return false;
        }
        try {
            List<String> theScript = this.plugin.getScriptEngine().getScriptHelper().getScriptContents(scriptName + ".SCRIPT");
            this.queueScriptEntries(npc, this.buildScriptEntries(npc, theScript, scriptName), ScriptEngine.QueueType.NPC);
        }
        catch (Exception e) {
            if (dB.showStackTraces) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean runTaskScript(DenizenNPC npc, Player player, String scriptName) {
        if (!aH.matchesScript("script:" + scriptName)) {
            return false;
        }
        try {
            List<String> theScript = this.plugin.getScriptEngine().getScriptHelper().getScriptContents(scriptName + ".SCRIPT");
            this.queueScriptEntries(npc, this.buildScriptEntries(player, npc, theScript, scriptName, null), ScriptEngine.QueueType.NPC);
        }
        catch (Exception e) {
            if (dB.showStackTraces) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean runTaskScriptInstantly(Player player, DenizenNPC npc, String scriptName) {
        if (!aH.matchesScript("script:" + scriptName)) {
            return false;
        }
        try {
            List<String> script = this.plugin.getScriptEngine().getScriptHelper().getStringListIgnoreCase(scriptName + ScriptHelper.scriptKey);
            if (script.isEmpty()) {
                return false;
            }
            List<ScriptEntry> scriptEntries = this.plugin.getScriptEngine().getScriptBuilder().buildScriptEntries(player, npc, script, scriptName, null);
            for (ScriptEntry scriptEntry : scriptEntries) {
                this.plugin.getScriptEngine().getScriptExecuter().execute(scriptEntry);
            }
        }
        catch (Exception e) {
            if (dB.showStackTraces) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }
}

