/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CastCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<Object> targets = new ArrayList<Object>();
        double duration = 60.0;
        int amplifier = 1;
        PotionEffectType potion = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                duration = aH.getSecondsFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("POWER", arg, aH.ArgumentType.Integer)) {
                amplifier = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("TARGETS, TARGET", arg, aH.ArgumentType.String)) {
                for (String t : aH.getListFrom(arg)) {
                    if (aH.getStringFrom(arg).equalsIgnoreCase("PLAYER") && scriptEntry.getPlayer() != null) {
                        if (scriptEntry.getPlayer() == null) {
                            dB.echoError("Cannot add PLAYER as a target! Attached Player is NULL!");
                            continue;
                        }
                        targets.add(scriptEntry.getPlayer());
                        continue;
                    }
                    if (aH.getStringFrom(arg).equalsIgnoreCase("NPC") && scriptEntry.getNPC() != null) {
                        if (scriptEntry.getNPC() == null) {
                            dB.echoError("Cannot add NPC as a target! Attached NPC is NULL!");
                            continue;
                        }
                        targets.add(scriptEntry.getNPC().getEntity());
                        continue;
                    }
                    if (aH.getLivingEntityFrom(arg) != null) {
                        targets.add(aH.getLivingEntityFrom(arg));
                        continue;
                    }
                    dB.echoError("Invalid TARGET type or unavailable TARGET object!");
                }
                continue;
            }
            if (potion == null) {
                try {
                    potion = PotionEffectType.getByName((String)aH.getStringFrom(arg));
                }
                catch (Exception e) {
                    dB.echoError("Invalid PotionEffectType!");
                }
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (targets.isEmpty() && scriptEntry.getPlayer() != null) {
            targets.add(scriptEntry.getPlayer());
        }
        if (targets.isEmpty() && scriptEntry.getNPC() != null) {
            targets.add(scriptEntry.getNPC().getEntity());
        }
        if (potion == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "PotionType");
        }
        if (targets.isEmpty()) {
            throw new InvalidArgumentsException("No valid target(s)! Perhaps you specified a non-existing Player or NPCID?");
        }
        PotionEffect potionEffect = new PotionEffect(potion, Double.valueOf(duration).intValue() * 20, amplifier);
        scriptEntry.addObject("potion", potionEffect);
        scriptEntry.addObject("targets", targets);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List targets = (List)scriptEntry.getObject("targets");
        PotionEffect potion = (PotionEffect)scriptEntry.getObject("potion");
        dB.echoDebug("<G>Executing '<Y>" + this.getName() + "<G>': " + "Targets='<Y>" + targets.toString() + "<G>', " + "POTION='<Y>" + potion.getType().getName() + "<G>', " + "DURATION='<Y>" + potion.getDuration() / 20 + "<G>', " + "AMPLIFIER='<Y>" + potion.getAmplifier() + "<G>'");
        for (LivingEntity target : targets) {
            if (potion.apply(target)) continue;
            dB.echoError("Bukkit was unable to apply '" + potion.getType().getName() + "' to '" + target.toString() + "'.");
        }
    }
}

