/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class AssignmentCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String script = null;
        Action action = Action.SET;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesScript(arg)) {
                script = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesArg("SET, REMOVE", arg)) {
                action = Action.valueOf(arg.toUpperCase());
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (script == null && action == Action.SET) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "SCRIPT");
        }
        if (scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        scriptEntry.addObject("script", script);
        scriptEntry.addObject("action", (Object)action);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        String script = (String)scriptEntry.getObject("script");
        dB.echoDebug("<G>Executing '<Y>" + this.getName() + "<G>': " + "Action='<Y>" + action.toString() + "<G>', " + (script != null ? "Script='<Y>" + script + "<G>', " : "") + "NPC='<Y>" + scriptEntry.getNPC() + "<G>'");
        if (action == Action.SET) {
            ((AssignmentTrait)scriptEntry.getNPC().getCitizen().getTrait(AssignmentTrait.class)).setAssignment(script, scriptEntry.getPlayer());
        } else if (action == Action.REMOVE) {
            ((AssignmentTrait)scriptEntry.getNPC().getCitizen().getTrait(AssignmentTrait.class)).removeAssignment(scriptEntry.getPlayer());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        SET,
        REMOVE;

    }
}

