/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ClearCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<ScriptEngine.QueueType> queues = new ArrayList<ScriptEngine.QueueType>();
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesQueueType(arg)) {
                queues.add(aH.getQueueFrom(arg));
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (queues.isEmpty()) {
            throw new InvalidArgumentsException("Must specify at least one queueType!");
        }
        scriptEntry.addObject("queues", queues);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List queues = (List)scriptEntry.getObject("queues");
        dB.echoApproval("<G>Executing '<Y>" + this.getName() + "<G>': " + "Queues=<Y>" + queues.toString() + "<G>'" + (scriptEntry.getPlayer() != null ? ", Player='<Y>" + scriptEntry.getPlayer().getName() + "<G>'" : "") + (scriptEntry.getNPC() != null ? ", NPC='<Y>" + scriptEntry.getNPC().getName() + "/" + scriptEntry.getNPC().getId() + "<G>'" : ""));
        ArrayList<ScriptEntry> emptyList = new ArrayList<ScriptEntry>();
        for (ScriptEngine.QueueType queue : queues) {
            if (queue == ScriptEngine.QueueType.PLAYER) {
                this.denizen.getScriptEngine().replaceQueue(scriptEntry.getPlayer(), emptyList, ScriptEngine.QueueType.PLAYER);
                continue;
            }
            if (queue == ScriptEngine.QueueType.PLAYER_TASK) {
                this.denizen.getScriptEngine().replaceQueue(scriptEntry.getPlayer(), emptyList, ScriptEngine.QueueType.PLAYER_TASK);
                continue;
            }
            if (queue != ScriptEngine.QueueType.NPC) continue;
            this.denizen.getScriptEngine().replaceQueue(scriptEntry.getNPC(), emptyList, ScriptEngine.QueueType.NPC);
        }
    }
}

