/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.Listener;

public class FlagCommand
extends AbstractCommand
implements Listener {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String name = null;
        String value = null;
        double duration = -1.0;
        Action action = Action.SET_VALUE;
        Type type = Type.PLAYER;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                duration = aH.getSecondsFrom(arg);
                continue;
            }
            if (aH.matchesArg("GLOBAL, NPC, DENIZEN, GLOBAL", arg)) {
                type = Type.valueOf(arg.toUpperCase().replace("DENIZEN", "NPC"));
                continue;
            }
            if (arg.split(":", 3).length > 1) {
                String[] flagArgs = arg.split(":");
                name = flagArgs[0].toUpperCase();
                if (flagArgs.length == 2) {
                    if (flagArgs[1].contains("+")) {
                        action = Action.INCREASE;
                        value = "1";
                        continue;
                    }
                    if (flagArgs[1].contains("-")) {
                        action = Action.DECREASE;
                        value = "1";
                        continue;
                    }
                    if (flagArgs[1].contains("!")) {
                        action = Action.DELETE;
                        continue;
                    }
                    if (flagArgs[1].contains("<-")) {
                        action = Action.REMOVE;
                        continue;
                    }
                    action = Action.SET_VALUE;
                    value = arg.split(":")[1];
                    continue;
                }
                if (flagArgs.length != 3) continue;
                if (flagArgs[1].contains("->")) {
                    action = Action.INSERT;
                } else if (flagArgs[1].contains("<-")) {
                    action = Action.REMOVE;
                } else if (flagArgs[1].contains("+")) {
                    action = Action.INCREASE;
                } else if (flagArgs[1].contains("-")) {
                    action = Action.DECREASE;
                } else if (flagArgs[1].contains("*")) {
                    action = Action.MULTIPLY;
                } else if (flagArgs[1].contains("/")) {
                    action = Action.DIVIDE;
                }
                value = flagArgs[2];
                continue;
            }
            name = arg.toUpperCase();
            action = Action.SET_BOOLEAN;
        }
        String player = null;
        if (type == Type.PLAYER) {
            if (scriptEntry.getOfflinePlayer() != null) {
                player = scriptEntry.getOfflinePlayer().getName();
            }
            if (player == null && scriptEntry.getPlayer() != null) {
                player = scriptEntry.getPlayer().getName();
            }
        }
        if (name == null) {
            throw new InvalidArgumentsException("Must specify a FLAG name.");
        }
        if (type == Type.NPC && scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException("Specified NPC-type flag with no valid NPC reference.");
        }
        if (type == Type.PLAYER && player == null) {
            throw new InvalidArgumentsException("Specified PLAYER-type flag with no valid Player reference.");
        }
        scriptEntry.addObject("name", name);
        scriptEntry.addObject("value", value);
        scriptEntry.addObject("duration", duration);
        scriptEntry.addObject("action", (Object)action);
        scriptEntry.addObject("type", (Object)type);
        scriptEntry.addObject("player", player);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String name = (String)scriptEntry.getObject("name");
        String value = (String)scriptEntry.getObject("value");
        Double duration = (Double)scriptEntry.getObject("duration");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        int index = -1;
        if (name.contains("[")) {
            try {
                index = Integer.valueOf(name.split("\\[")[1].replace("]", ""));
            }
            catch (Exception e) {
                index = -1;
            }
            name = name.split("\\[")[0];
        }
        FlagManager.Flag flag = null;
        String player = (String)scriptEntry.getObject("player");
        dB.echoApproval("<G>Executing '<Y>" + this.getName() + "': " + "Name='" + name + "', " + (index > 0 ? "Index='" + index + "', " : "") + "Type='" + (Object)((Object)type) + "', " + "Action/Value='" + action.toString() + "(" + (value != null ? value : "null") + ")'" + (duration > 0.0 ? "Duration='" + duration + "'" : "") + (type == Type.NPC ? "NPC='" + scriptEntry.getNPC() + "'" : "") + (type == Type.PLAYER ? "Player='" + player + "'" : ""));
        switch (type) {
            case NPC: {
                flag = this.denizen.flagManager().getNPCFlag(scriptEntry.getNPC().getId(), name);
                break;
            }
            case PLAYER: {
                flag = this.denizen.flagManager().getPlayerFlag(player, name);
                break;
            }
            case GLOBAL: {
                flag = this.denizen.flagManager().getGlobalFlag(name);
            }
        }
        switch (action) {
            case INCREASE: 
            case DECREASE: 
            case MULTIPLY: 
            case DIVIDE: {
                double currentValue = flag.get(index).asDouble();
                flag.set(Double.toString(this.math(currentValue, Double.valueOf(value), action)), index);
                break;
            }
            case SET_BOOLEAN: {
                flag.set(true, index);
                break;
            }
            case SET_VALUE: {
                flag.set(value, index);
                break;
            }
            case INSERT: {
                flag.add(value);
                break;
            }
            case REMOVE: {
                flag.remove(value, index);
                break;
            }
            case DELETE: {
                flag.clear();
            }
        }
        if (duration > 0.0) {
            flag.setExpiration(System.currentTimeMillis() + Double.valueOf(duration * 1000.0).longValue());
        }
    }

    private double math(double currentValue, double value, Action flagAction) {
        switch (flagAction) {
            case INCREASE: {
                return currentValue + value;
            }
            case DECREASE: {
                return currentValue - value;
            }
            case MULTIPLY: {
                return currentValue * value;
            }
            case DIVIDE: {
                return currentValue / value;
            }
        }
        return 0.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        GLOBAL,
        NPC,
        PLAYER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        SET_VALUE,
        SET_BOOLEAN,
        INCREASE,
        DECREASE,
        MULTIPLY,
        DIVIDE,
        INSERT,
        REMOVE,
        DELETE;

    }
}

