/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ListenerCancelEvent;
import net.aufdemrand.denizen.events.ListenerFinishEvent;
import net.aufdemrand.denizen.interfaces.DenizenRegistry;
import net.aufdemrand.denizen.interfaces.RegistrationableInstance;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.listeners.AbstractListenerType;
import net.aufdemrand.denizen.listeners.core.BlockListenerInstance;
import net.aufdemrand.denizen.listeners.core.BlockListenerType;
import net.aufdemrand.denizen.listeners.core.ItemListenerInstance;
import net.aufdemrand.denizen.listeners.core.ItemListenerType;
import net.aufdemrand.denizen.listeners.core.KillListenerInstance;
import net.aufdemrand.denizen.listeners.core.KillListenerType;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerRegistry
implements DenizenRegistry,
Listener {
    private Map<String, Map<String, AbstractListener>> listeners = new ConcurrentHashMap<String, Map<String, AbstractListener>>();
    private Map<String, AbstractListenerType> types = new ConcurrentHashMap<String, AbstractListenerType>();
    private Denizen denizen;

    public ListenerRegistry(Denizen denizen) {
        this.denizen = denizen;
    }

    public void addListenerFor(Player player, AbstractListener instance, String listenerId) {
        Map<String, AbstractListener> playerListeners = this.listeners.containsKey(player.getName()) ? this.listeners.get(player.getName()) : new HashMap<String, AbstractListener>();
        playerListeners.put(listenerId.toLowerCase(), instance);
        this.listeners.put(player.getName(), playerListeners);
    }

    public void cancel(Player player, String listenerId, AbstractListener instance) {
        this.removeListenerFor(player, listenerId);
        Bukkit.getPluginManager().callEvent((Event)new ListenerCancelEvent(player, listenerId));
    }

    @Override
    public void disableCoreMembers() {
        for (AbstractListenerType member : this.types.values()) {
            try {
                member.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + member.getClass().getName() + "'!");
                if (!dB.showStackTraces) continue;
                e.printStackTrace();
            }
        }
    }

    public void finish(Player player, String listenerId, String finishScript, AbstractListener instance) {
        if (finishScript != null) {
            this.denizen.getScriptEngine().getScriptBuilder().runTaskScript(player, finishScript);
        }
        this.removeListenerFor(player, listenerId);
        Bukkit.getPluginManager().callEvent((Event)new ListenerFinishEvent(player, listenerId));
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        if (this.types.containsValue(clazz)) {
            for (AbstractListenerType asl : this.types.values()) {
                if (asl.getClass() != clazz) continue;
                return (T)((RegistrationableInstance)clazz.cast(asl));
            }
        }
        return null;
    }

    @Override
    public AbstractListenerType get(String listenerType) {
        if (this.types.containsKey(listenerType.toUpperCase())) {
            return this.types.get(listenerType.toUpperCase());
        }
        return null;
    }

    public AbstractListener getListenerFor(OfflinePlayer player, String listenerId) {
        Map<String, AbstractListener> playerListeners;
        if (this.listeners.containsKey(player.getName()) && (playerListeners = this.listeners.get(player.getName())).containsKey(listenerId.toLowerCase())) {
            return playerListeners.get(listenerId.toLowerCase());
        }
        return null;
    }

    public Map<String, AbstractListener> getListenersFor(OfflinePlayer player) {
        if (this.listeners.containsKey(player.getName())) {
            Map<String, AbstractListener> playerListeners = this.listeners.get(player.getName());
            return playerListeners;
        }
        return null;
    }

    public Map<String, AbstractListenerType> list() {
        return this.types;
    }

    @EventHandler
    public void playerJoin(PlayerJoinEvent event) {
        if (!this.denizen.getSaves().contains("Listeners." + event.getPlayer().getName())) {
            return;
        }
        Set inProgress = this.denizen.getSaves().getConfigurationSection("Listeners." + event.getPlayer().getName()).getKeys(false);
        if (inProgress.isEmpty()) {
            return;
        }
        String path = "Listeners." + event.getPlayer().getName() + ".";
        for (String listenerId : inProgress) {
            try {
                String type = this.denizen.getSaves().getString(path + listenerId + ".Listener Type");
                if (this.get(type) == null) {
                    return;
                }
                dB.log(event.getPlayer().getName() + " has a LISTENER in progress. Loading '" + listenerId + "'.");
                this.get(type).createInstance(event.getPlayer(), listenerId).load(event.getPlayer(), listenerId, type);
            }
            catch (Exception e) {
                dB.log(event.getPlayer() + " has a saved listener named '" + listenerId + "' that may be corrupt. Skipping for now, but perhaps check the contents of your saves.yml for problems?");
            }
        }
    }

    public void deconstructPlayer(OfflinePlayer player) {
        this.denizen.getSaves().set("Listeners." + player.getName(), null);
        if (!this.listeners.containsKey(player.getName())) {
            return;
        }
        for (Map.Entry<String, AbstractListener> entry : this.getListenersFor(player).entrySet()) {
            dB.log(player.getName() + " has a LISTENER in progress. Saving '" + entry.getKey() + "'.");
            entry.getValue().save();
        }
        this.listeners.remove(player);
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        this.deconstructPlayer((OfflinePlayer)event.getPlayer());
    }

    @Override
    public boolean register(String registrationName, RegistrationableInstance listenerType) {
        this.types.put(registrationName, (AbstractListenerType)listenerType);
        return false;
    }

    @Override
    public void registerCoreMembers() {
        new BlockListenerType().activate().as("BLOCK").withClass(BlockListenerInstance.class);
        new ItemListenerType().activate().as("ITEM").withClass(ItemListenerInstance.class);
        new KillListenerType().activate().as("KILL").withClass(KillListenerInstance.class);
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public void removeListenerFor(Player player, String listenerId) {
        if (!this.listeners.containsKey(player.getName())) {
            return;
        }
        Map<String, AbstractListener> playerListeners = this.listeners.get(player.getName());
        playerListeners.remove(listenerId.toLowerCase());
        this.listeners.put(player.getName(), playerListeners);
    }
}

