/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements.core;

import java.util.List;
import net.aufdemrand.denizen.exceptions.RequirementCheckException;
import net.aufdemrand.denizen.scripts.requirements.AbstractRequirement;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.utilities.Depends;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoneyRequirement
extends AbstractRequirement {
    private Double quantity;
    private Double balance;
    boolean outcome = false;

    @Override
    public boolean check(RequirementsContext context, List<String> args) throws RequirementCheckException {
        for (String arg : args) {
            if (aH.matchesQuantity(arg) || aH.matchesInteger(arg) || aH.matchesDouble(arg)) {
                this.quantity = aH.getDoubleFrom(arg);
                dB.echoDebug("...quantity set to: " + this.quantity);
                continue;
            }
            throw new RequirementCheckException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (Depends.economy != null) {
            this.balance = Depends.economy.getBalance(context.getPlayer().getName());
            dB.echoDebug("...player balance: " + this.balance);
        } else {
            dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
        }
        this.outcome = this.balance >= this.quantity;
        return this.outcome;
    }
}

