/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.LookClose;

public class LookcloseCommand
extends AbstractCommand {
    boolean toggle;
    boolean realistic;
    Double range;
    NPC npc;
    String[] realisticArgs = "/npc lookclose -r".split(" ");

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.npc = null;
        this.range = null;
        this.realistic = false;
        this.toggle = true;
        if (scriptEntry.getNPC() != null) {
            this.npc = scriptEntry.getNPC().getCitizen();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("REALISTIC", arg)) {
                this.realistic = true;
                dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, arg);
                continue;
            }
            if (aH.matchesValueArg("RANGE", arg, aH.ArgumentType.Double)) {
                this.range = aH.getDoubleFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_RANGE, String.valueOf(this.range));
                continue;
            }
            if (aH.matchesToggle(arg)) {
                this.toggle = aH.getBooleanFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_TOGGLE, String.valueOf(this.toggle));
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        if (this.npc == null) {
            throw new CommandExecutionException(dB.Messages.ERROR_NO_NPCID);
        }
        LookClose trait = (LookClose)this.npc.getTrait(LookClose.class);
        trait.lookClose(this.toggle);
        if (this.realistic) {
            // empty if block
        }
        if (this.range != null) {
            String[] stringArray = ("npc lookclose --range " + this.range).split(" ");
        }
    }

    public void onEnable() {
    }
}

