/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements.core;

import java.util.List;
import net.aufdemrand.denizen.exceptions.RequirementCheckException;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.scripts.requirements.AbstractRequirement;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlaggedRequirement
extends AbstractRequirement {
    @Override
    public boolean check(RequirementsContext context, List<String> args) throws RequirementCheckException {
        boolean outcome = false;
        Enum type = null;
        String flag = "";
        for (String arg : args) {
            String[] flagList = arg.split(":");
            if (flagList.length < 2) continue;
            String typeName = flagList[0].toUpperCase();
            if (typeName.startsWith("P")) {
                type = FlagType.PLAYER;
            } else if (typeName.startsWith("N")) {
                type = FlagType.NPC;
            } else if (typeName.startsWith("G")) {
                type = FlagType.GLOBAL;
            }
            flag = arg.substring(typeName.length() + 1, arg.length());
        }
        FlagManager flagMng = DenizenAPI.getCurrentInstance().flagManager();
        switch (1.$SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$FlaggedRequirement$FlagType[type.ordinal()]) {
            case 1: {
                Player player = context.getPlayer();
                if (player == null) break;
                outcome = flagMng.getPlayerFlag(player.getName(), flag).size() > 0;
                break;
            }
            case 2: {
                NPC npc = context.getNPC();
                if (npc == null) break;
                outcome = flagMng.getNPCFlag(npc.getId(), flag).size() > 0;
                break;
            }
            case 3: {
                outcome = flagMng.getGlobalFlag(flag).size() > 0;
            }
        }
        return outcome;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$FlaggedRequirement$FlagType;

        static {
            $SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$FlaggedRequirement$FlagType = new int[FlagType.values().length];
            try {
                1.$SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$FlaggedRequirement$FlagType[FlagType.PLAYER.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$FlaggedRequirement$FlagType[FlagType.NPC.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$FlaggedRequirement$FlagType[FlagType.GLOBAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FlagType {
        GLOBAL,
        NPC,
        PLAYER;

    }
}

