/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements.core;

import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.List;
import net.aufdemrand.denizen.exceptions.RequirementCheckException;
import net.aufdemrand.denizen.scripts.requirements.AbstractRequirement;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.utilities.Depends;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldGuardRegionRequirement
extends AbstractRequirement {
    @Override
    public void onEnable() {
    }

    @Override
    public boolean check(RequirementsContext context, List<String> args) throws RequirementCheckException {
        boolean outcome = false;
        boolean inRegion = false;
        World theWorld = context.getPlayer().getWorld();
        Location playerLocation = context.getPlayer().getLocation();
        if (args == null) {
            throw new RequirementCheckException("Must provide a NAME:regionname!");
        }
        block0: for (String thisArg : args) {
            if (thisArg.contains("NAME:")) {
                dB.echoDebug("...checking if player is in region!");
                String argRegion = aH.getStringFrom(thisArg);
                dB.echoDebug("...region to check: " + argRegion);
                ApplicableRegionSet currentRegions = Depends.worldGuard.getRegionManager(theWorld).getApplicableRegions(playerLocation);
                for (ProtectedRegion thisRegion : currentRegions) {
                    dB.echoDebug("...checking current player region: " + thisRegion.getId());
                    if (thisRegion.getId().contains(argRegion)) {
                        inRegion = true;
                        dB.echoDebug("...matched region");
                    }
                    if (!inRegion) continue;
                    continue block0;
                }
                continue;
            }
            dB.echoError("Could not match argument '%s'!", thisArg);
        }
        if (inRegion) {
            outcome = true;
        }
        if (outcome) {
            dB.echoDebug("...player in region!");
        } else {
            dB.echoDebug("...player is not in region!");
        }
        return outcome;
    }
}

