/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.scripts.commands.core.CooldownCommand;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.scripts.requirements.RequirementsMode;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptHelper {
    Denizen denizen;
    public static String scriptKey = ".SCRIPT";

    public ScriptHelper(Denizen denizenPlugin) {
        this.denizen = denizenPlugin;
    }

    public String getInteractScript(NPC npc, Player player, Class<? extends AbstractTrigger> trigger) {
        if (npc == null || player == null) {
            return null;
        }
        String theScript = null;
        List<String> assignedScripts = this.denizen.getScriptEngine().getScriptHelper().getStringListIgnoreCase(((AssignmentTrait)npc.getTrait(AssignmentTrait.class)).getAssignment() + ".INTERACT SCRIPTS");
        if (assignedScripts.isEmpty()) {
            return null;
        }
        dB.echoDebug(dB.DebugElement.Header, "Getting interact script: " + npc.getName() + "/" + player.getName());
        ArrayList<PriorityPair> interactableScripts = new ArrayList<PriorityPair>();
        for (String assignment : assignedScripts) {
            Integer priority;
            String script;
            block18: {
                assignment = assignment.toUpperCase();
                script = null;
                if (Character.isDigit(assignment.charAt(0))) {
                    try {
                        priority = Integer.valueOf(assignment.split(" ", 2)[0]);
                        script = assignment.split(" ", 2)[1].replace("^", "");
                        break block18;
                    }
                    catch (Exception e) {
                        dB.echoError("Invalid Interact assignment for '" + assignment + "'. Is the script name missing?");
                        continue;
                    }
                }
                dB.echoError("Script '" + script + "' has an invalid priority! Assuming '0'.");
                script = assignment;
                assignment = "0 " + assignment;
                priority = 0;
            }
            try {
                if (this.denizen.getScriptEngine().getRequirementChecker().check(this.buildInteractScriptRequirementContext(player, npc, script))) {
                    dB.echoApproval("'" + assignment + "' meets requirements.");
                    if (this.denizen.getCommandRegistry().get(CooldownCommand.class).checkCooldown(player.getName(), script)) {
                        interactableScripts.add(new PriorityPair(priority, assignment.split(" ", 2)[1]));
                    } else {
                        dB.echoDebug(ChatColor.GOLD + " ...but, isn't cooled down, yet! Skipping.");
                    }
                } else {
                    dB.echoDebug("'" + assignment + "' does not meet requirements.");
                }
            }
            catch (Exception e) {
                dB.echoError(ChatColor.RED + "'" + assignment + "' has a bad requirement, skipping.");
            }
            dB.echoDebug(dB.DebugElement.Spacer);
        }
        if (interactableScripts.size() == 1) {
            theScript = ((PriorityPair)interactableScripts.get(0)).getName();
            dB.echoApproval("Highest scoring script is " + theScript + ".");
            dB.echoDebug(dB.DebugElement.Footer);
            return theScript.replace("^", "");
        }
        if (interactableScripts.isEmpty()) {
            dB.echoDebug(ChatColor.YELLOW + "Uh oh!" + ChatColor.WHITE + " No scripts meet requirements!");
            dB.echoDebug(dB.DebugElement.Footer);
            return null;
        }
        Collections.sort(interactableScripts);
        for (int a = interactableScripts.size() - 1; a >= 0; --a) {
            dB.echoDebug("Checking script '" + ((PriorityPair)interactableScripts.get(a)).getName() + "'.");
            if (((PriorityPair)interactableScripts.get(a)).getName().startsWith("^")) {
                String scriptName = ((PriorityPair)interactableScripts.get(a)).getName().substring(1);
                String triggerString = this.denizen.getTriggerRegistry().get(trigger).getName().toUpperCase() + " TRIGGER";
                if (this.denizen.getScripts().contains(scriptName.toUpperCase() + ".STEPS." + this.getCurrentStep(player, scriptName) + "." + triggerString)) {
                    dB.echoDebug("...found trigger!");
                    dB.echoApproval("Highest scoring script is " + scriptName + ".");
                    dB.echoDebug(dB.DebugElement.Footer);
                    return scriptName.replace("^", "");
                }
            } else {
                dB.echoDebug("...script is good!");
                dB.echoApproval("Highest scoring script is " + ((PriorityPair)interactableScripts.get(a)).getName() + ".");
                dB.echoDebug(dB.DebugElement.Footer);
                return ((PriorityPair)interactableScripts.get(a)).getName().replace("^", "");
            }
            dB.echoDebug("...no trigger on this overlay assignment. Skipping.");
        }
        return null;
    }

    private RequirementsContext buildInteractScriptRequirementContext(Player player, NPC npc, String scriptName) {
        List reqList = this.denizen.getScripts().getStringList(scriptName + ".REQUIREMENTS.LIST");
        RequirementsMode reqMode = new RequirementsMode(this.denizen.getScripts().getString(scriptName + ".REQUIREMENTS.MODE", "NONE"));
        if (reqList.isEmpty() && reqMode.getMode() != RequirementsMode.Mode.NONE) {
            dB.echoError("Non-valid requirements structure at:");
            dB.echoDebug(ChatColor.GRAY + scriptName + ":");
            dB.echoDebug(ChatColor.GRAY + "  Requirements:");
            dB.echoDebug(ChatColor.GRAY + "    Mode: ???");
            dB.echoDebug(ChatColor.GRAY + "    List:");
            dB.echoDebug(ChatColor.GRAY + "    - ???");
            dB.echoDebug("* Check spacing, validate structure and spelling.");
            return null;
        }
        return new RequirementsContext(reqMode, reqList, scriptName).attachNPC(npc).attachPlayer(player);
    }

    public String getCurrentStep(Player player, String scriptName) {
        return this.getCurrentStep(player, scriptName, true);
    }

    public String getCurrentStep(Player player, String scriptName, Boolean verbose) {
        String current = "DEFAULT";
        if (this.denizen.getSaves().getString("Players." + player.getName() + ".Scripts." + scriptName.toUpperCase() + "." + "Current Step") != null) {
            current = this.denizen.getSaves().getString("Players." + player.getName() + ".Scripts." + scriptName.toUpperCase() + "." + "Current Step");
            if (verbose.booleanValue()) {
                dB.echoDebug("Getting current step... found '" + current + "'");
            }
            return current;
        }
        if (this.denizen.getScripts().contains(scriptName.toUpperCase())) {
            Set steps = this.denizen.getScripts().getConfigurationSection(scriptName.toUpperCase() + ".STEPS").getKeys(false);
            if (steps.contains("1")) {
                current = "1";
            }
            for (String step : steps) {
                if (!step.endsWith("*")) continue;
                current = step;
            }
        }
        if (verbose.booleanValue()) {
            dB.echoDebug("Getting current step... not found, assuming '" + current + "'");
        }
        return current;
    }

    public String getTriggerScriptPath(String scriptName, String step, String triggerName) {
        return scriptName.toUpperCase() + ".STEPS." + step + "." + triggerName.toUpperCase() + " TRIGGER.";
    }

    public List<String> getScriptContents(String path) {
        List<String> contents = new ArrayList<String>();
        path = path.toUpperCase().replace("..", ".");
        if (this.denizen.getScripts().contains(path.toUpperCase())) {
            contents = this.denizen.getScripts().getStringList(path.toUpperCase());
        }
        if (contents.isEmpty()) {
            if (path.toUpperCase().contains("TRIGGER")) {
                String[] context = path.split("\\.");
                if (context.length >= 4) {
                    dB.echoDebug(ChatColor.YELLOW + "INFO +> " + ChatColor.WHITE + "No " + context[3] + " for '" + context[0].toUpperCase() + "/" + context[2].toUpperCase() + "'");
                }
                return contents;
            }
            dB.echoDebug(ChatColor.YELLOW + "WARNING: " + ChatColor.WHITE + "Unable to locate script at:");
            String spacing = "";
            for (String node : path.split("\\.")) {
                dB.echoDebug(spacing + node + ":");
                spacing = spacing + "  ";
            }
            dB.echoDebug(spacing.substring(0, spacing.length() - 1) + "- ???");
            dB.echoDebug("This script may not exist, or structure may be incorrect. Validate structure and spelling.");
        }
        return contents;
    }

    public String concatenateScripts() {
        block9: {
            try {
                File file = new File(this.denizen.getDataFolder() + File.separator + "scripts");
                if (!file.exists()) {
                    throw new Exception("No script folder found, please create one first!");
                }
                File[] files = file.listFiles();
                if (files.length > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (File f : files) {
                        String fileName = f.getName();
                        if (!fileName.substring(fileName.lastIndexOf(46) + 1).equalsIgnoreCase("YML") && !fileName.substring(fileName.lastIndexOf(46) + 1).equalsIgnoreCase("DSCRIPT") && (!fileName.substring(fileName.lastIndexOf(46) + 1).equalsIgnoreCase("YAML") || fileName.startsWith("."))) continue;
                        dB.echoDebug("Processing '" + fileName + "'... ");
                        try {
                            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)f);
                            if (yaml != null) {
                                sb.append(yaml.saveToString() + "\r\n");
                                continue;
                            }
                            dB.echoError(ChatColor.RED + "Woah! Error parsing " + fileName + "! This script has been skipped. See console for YAML errors.");
                        }
                        catch (RuntimeException e) {
                            dB.echoError(ChatColor.RED + "Woah! Error parsing " + fileName + "!");
                            if (dB.showStackTraces) {
                                dB.echoDebug("STACKTRACE follows:");
                                e.printStackTrace();
                                continue;
                            }
                            dB.echoDebug("Use '/denizen debug -s' for the nitty-gritty.");
                        }
                    }
                    dB.echoApproval("All scripts loaded!");
                    return this.yamlKeysToUpperCase(sb.toString());
                }
                dB.echoError(ChatColor.RED + "Woah! No scripts in /plugins/Denizen/scripts/ to load!");
            }
            catch (Exception error) {
                dB.echoError(ChatColor.RED + "Woah! No script folder found in /plugins/Denizen/scripts/");
                if (!dB.showStackTraces) break block9;
                error.printStackTrace();
            }
        }
        return "";
    }

    public int getIntIgnoreCase(String path) {
        return this.denizen.getScripts().getInt(path.toUpperCase());
    }

    public String getStringIgnoreCase(String path) {
        return this.denizen.getScripts().getString(path.toUpperCase());
    }

    public List<String> getStringListIgnoreCase(String path) {
        return this.denizen.getScripts().getStringList(path.toUpperCase());
    }

    public int getIntIgnoreCase(String path, int def) {
        return this.denizen.getScripts().getInt(path.toUpperCase(), def);
    }

    public String getStringIgnoreCase(String path, String def) {
        return this.denizen.getScripts().getString(path.toUpperCase(), def);
    }

    private String yamlKeysToUpperCase(String string) {
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("(^[^:-]*?[^\\s]:)", 8);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group().toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PriorityPair
    implements Comparable<PriorityPair> {
        int priority;
        private String name;

        public PriorityPair(int priority, String scriptName) {
            this.priority = priority;
            this.name = scriptName.toUpperCase();
        }

        @Override
        public int compareTo(PriorityPair pair) {
            return this.priority < pair.priority ? -1 : (this.priority > pair.priority ? 1 : 0);
        }

        public String getName() {
            return this.name;
        }
    }
}

