/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.commands.core.EngageCommand;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.npc.NPC;
import net.minecraft.server.v1_4_R1.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftLivingEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dNPC {
    private NPC npc;
    private int npcid;
    private Denizen plugin;
    private ScriptHelper sH;

    dNPC(NPC citizensNPC) {
        this.npc = citizensNPC;
        this.npcid = citizensNPC.getId();
        this.plugin = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
        this.sH = this.plugin.getScriptEngine().getScriptHelper();
    }

    public EntityLiving getHandle() {
        return ((CraftLivingEntity)this.getEntity()).getHandle();
    }

    public NPC getCitizen() {
        if (this.npc != null) {
            return this.npc;
        }
        this.npc = CitizensAPI.getNPCRegistry().getById(this.npcid);
        if (this.npc == null) {
            dB.log("Uh oh! Denizen has encountered an NPE while trying to fetch a NPC. Has this NPC been removed?");
        }
        return this.npc;
    }

    public LivingEntity getEntity() {
        try {
            return this.getCitizen().getBukkitEntity();
        }
        catch (NullPointerException e) {
            dB.log("Uh oh! Denizen has encountered an NPE while trying to fetch a NPC entity. Has this NPC been removed?");
            return null;
        }
    }

    public EntityType getEntityType() {
        return this.getCitizen().getBukkitEntity().getType();
    }

    public Navigator getNavigator() {
        return this.getCitizen().getNavigator();
    }

    public int getId() {
        return this.getCitizen().getId();
    }

    public String getName() {
        return this.getCitizen().getName();
    }

    public String getInteractScript(Player thePlayer, Class<? extends AbstractTrigger> triggerType) {
        return this.sH.getInteractScript(this.getCitizen(), thePlayer, triggerType);
    }

    public boolean isSpawned() {
        return this.getCitizen().isSpawned();
    }

    public Location getLocation() {
        return this.getCitizen().getBukkitEntity().getLocation();
    }

    public World getWorld() {
        return this.getCitizen().getBukkitEntity().getWorld();
    }

    public void setHealth(int newHealth) {
        ((CraftLivingEntity)this.getEntity()).getHandle().setHealth(newHealth);
    }

    public int getHealth() {
        return ((CraftLivingEntity)this.getEntity()).getHandle().getHealth();
    }

    public String toString() {
        return this.getCitizen().getName() + "/" + this.getCitizen().getId();
    }

    public boolean isInteracting() {
        this.plugin.getCommandRegistry().get(EngageCommand.class);
        return !EngageCommand.getEngaged(this.getCitizen());
    }

    public String getAssignment() {
        if (this.getCitizen().hasTrait(AssignmentTrait.class)) {
            return ((AssignmentTrait)this.getCitizen().getTrait(AssignmentTrait.class)).getAssignment();
        }
        return null;
    }

    public boolean hasAssignment() {
        if (!this.getCitizen().hasTrait(AssignmentTrait.class)) {
            return false;
        }
        return ((AssignmentTrait)this.getCitizen().getTrait(AssignmentTrait.class)).hasAssignment();
    }

    public boolean setAssignment(String assignment, Player player) {
        if (!this.getCitizen().hasTrait(AssignmentTrait.class)) {
            this.getCitizen().addTrait(AssignmentTrait.class);
        }
        return ((AssignmentTrait)this.getCitizen().getTrait(AssignmentTrait.class)).setAssignment(assignment, player);
    }

    public void action(String actionName, Player player) {
        if (this.getCitizen().hasTrait(AssignmentTrait.class)) {
            this.plugin.getNPCRegistry().getActionHandler().doAction(actionName, this, player, this.getAssignment());
        }
    }
}

