/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.utilities.Depends;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameplateTrait
extends Trait
implements Listener {
    @Persist(value="")
    private ChatColor color = null;

    public NameplateTrait() {
        super("nameplate");
    }

    public void onSpawn() {
        if (this.getColor() != null) {
            this.refreshTag(this.getNPC());
        }
    }

    public void setColor(ChatColor color) {
        this.color = color;
        this.refreshTag(this.getNPC());
    }

    public ChatColor getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return this.getColor() != null;
    }

    public String getTrimmedTag() {
        String tag = this.getNPC().getName();
        if (this.color != null) {
            tag = this.getColor() + tag;
        }
        if (tag.length() > 16) {
            tag = tag.substring(0, 16);
        }
        return tag;
    }

    public void refreshTag(NPC npc) {
        if (Depends.protocolManager == null || !npc.isSpawned()) {
            return;
        }
        int maxDistance = Bukkit.getServer().getViewDistance() * 16;
        ArrayList<Player> viewers = new ArrayList<Player>();
        for (Player p : this.getPlayersInRadius(npc, maxDistance)) {
            if (p.getEntityId() == npc.getBukkitEntity().getEntityId()) continue;
            viewers.add(p);
        }
        this.refreshTag(npc, viewers);
    }

    private void refreshTag(NPC npc, List<Player> players) {
        try {
            Depends.protocolManager.updateEntity((Entity)npc.getBukkitEntity(), players);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Player> getPlayersInRadius(NPC npc, int distance) {
        ArrayList<Player> players = new ArrayList<Player>();
        int dSquared = distance * distance;
        Location loc = npc.getBukkitEntity().getLocation();
        World world = npc.getBukkitEntity().getWorld();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p.getWorld() != world || !(p.getLocation().distanceSquared(loc) <= (double)dSquared)) continue;
            players.add(p);
        }
        return players;
    }
}

