/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.runnables.Runnable2;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class RuntaskCommand
extends AbstractCommand {
    private static Map<String, Integer> delays = new ConcurrentHashMap<String, Integer>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String id = null;
        String script = null;
        Duration delay = new Duration(-1.0);
        boolean instant = false;
        ScriptEngine.QueueType queue = scriptEntry.getPlayer() != null ? ScriptEngine.QueueType.PLAYER_TASK : ScriptEngine.QueueType.NPC;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesScript(arg)) {
                script = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("DELAY", arg, aH.ArgumentType.Duration)) {
                delay = aH.getDurationFrom(arg);
                delay.setPrefix("Delay");
                continue;
            }
            if (aH.matchesArg("INSTANT", arg)) {
                instant = true;
                continue;
            }
            if (aH.matchesQueueType(arg)) {
                queue = aH.getQueueFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("ID", arg, aH.ArgumentType.Word)) {
                id = aH.getStringFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if ((queue == ScriptEngine.QueueType.PLAYER || queue == ScriptEngine.QueueType.PLAYER_TASK) && scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException("Player cannot be null when using a 'Player' Queue.");
        }
        if (queue == ScriptEngine.QueueType.NPC && scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException("NPC cannot be null when using a 'NPC' Queue.");
        }
        if (script == null) {
            throw new InvalidArgumentsException("Must define a script to be run!");
        }
        if (id == null) {
            id = script;
        }
        scriptEntry.addObject("id", id);
        scriptEntry.addObject("queue", (Object)queue);
        scriptEntry.addObject("delay", delay);
        scriptEntry.addObject("script", script);
        scriptEntry.addObject("instant", instant);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String script = (String)scriptEntry.getObject("script");
        ScriptEngine.QueueType queue = (ScriptEngine.QueueType)((Object)scriptEntry.getObject("queue"));
        Boolean instant = (Boolean)scriptEntry.getObject("instant");
        Duration delay = (Duration)scriptEntry.getObject("delay");
        dB.echoApproval("Executing '" + this.getName() + "': " + "Script='" + script + "', " + delay.debug() + "Player='" + (scriptEntry.getPlayer() != null ? scriptEntry.getPlayer().getName() + "', " : "NULL', ") + "NPC='" + (scriptEntry.getNPC() != null ? scriptEntry.getNPC() + "', " : "NULL', ") + "Queue='" + (instant == false ? queue.toString() + "'" : "INSTANT'"));
        if (delay.getSeconds() <= 0.0) {
            if (instant.booleanValue()) {
                this.denizen.getScriptEngine().getScriptBuilder().runTaskScriptInstantly(scriptEntry.getPlayer(), scriptEntry.getNPC(), script);
            } else {
                switch (queue) {
                    case PLAYER: 
                    case PLAYER_TASK: {
                        this.denizen.getScriptEngine().getScriptBuilder().runTaskScript(scriptEntry.getPlayer(), scriptEntry.getNPC(), script);
                        break;
                    }
                    case NPC: {
                        this.denizen.getScriptEngine().getScriptBuilder().runTaskScript(scriptEntry.getNPC(), scriptEntry.getPlayer(), script);
                    }
                }
            }
            if (delays.containsKey(((String)scriptEntry.getObject("id")).toUpperCase())) {
                delays.remove(((String)scriptEntry.getObject("id")).toUpperCase());
            }
        } else {
            String id = ((String)scriptEntry.getObject("id")).toUpperCase();
            long ldelay = (long)(((Duration)scriptEntry.getObject("delay")).getSeconds() * 20.0);
            scriptEntry.addObject("delay", new Duration(0));
            dB.echoDebug(dB.Messages.DEBUG_SETTING_DELAYED_TASK, "Run TASK SCRIPT '" + script + "'");
            delays.put(id, this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, (Runnable)new Runnable2<String, ScriptEntry>(script, scriptEntry){

                @Override
                public void run(String script, ScriptEntry scriptEntry) {
                    block2: {
                        dB.log(dB.Messages.DEBUG_RUNNING_DELAYED_TASK, "Run TASK SCRIPT '" + script + "'");
                        try {
                            RuntaskCommand.this.execute(scriptEntry);
                        }
                        catch (CommandExecutionException e) {
                            dB.echoError("Could not run delayed task!");
                            if (!dB.showStackTraces) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            }, ldelay));
        }
    }

    public static boolean cancelTask(String id) {
        if (delays.containsKey(id.toUpperCase())) {
            block3: {
                try {
                    Bukkit.getServer().getScheduler().cancelTask(delays.get(id.toUpperCase()).intValue());
                }
                catch (Exception e) {
                    dB.echoError("Could not cancel task!");
                    if (!dB.showStackTraces) break block3;
                    e.printStackTrace();
                }
            }
            delays.remove(id.toUpperCase());
            return true;
        }
        return false;
    }
}

