/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements.core;

import java.util.List;
import net.aufdemrand.denizen.exceptions.RequirementCheckException;
import net.aufdemrand.denizen.scripts.commands.core.FailCommand;
import net.aufdemrand.denizen.scripts.commands.core.FinishCommand;
import net.aufdemrand.denizen.scripts.requirements.AbstractRequirement;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptRequirement
extends AbstractRequirement {
    @Override
    public void onEnable() {
    }

    @Override
    public boolean check(RequirementsContext context, List<String> args) throws RequirementCheckException {
        boolean outcome = false;
        Enum scriptCheck = null;
        Integer step = null;
        Integer quantity = 1;
        boolean exactly = false;
        String checkScript = null;
        for (String thisArg : args) {
            if (aH.matchesValueArg("FINISHED", thisArg, aH.ArgumentType.Custom) || aH.matchesValueArg("FAILED", thisArg, aH.ArgumentType.Custom) || aH.matchesValueArg("STEP", thisArg, aH.ArgumentType.Custom)) {
                scriptCheck = ScriptCheck.valueOf(aH.getStringFrom(thisArg));
                dB.echoDebug("...checking '%s'.", aH.getStringFrom(thisArg));
                continue;
            }
            if (aH.matchesScript(thisArg)) {
                checkScript = aH.getStringFrom(thisArg);
                dB.echoDebug("...script to check is '%s'.", checkScript);
                continue;
            }
            if (thisArg.toUpperCase().matches("(?:STEP)(:)(\\d+)")) {
                step = aH.getIntegerFrom(thisArg);
                dB.echoDebug("...step to check is '%s'.", step.toString());
                continue;
            }
            if (aH.matchesQuantity(thisArg)) {
                quantity = aH.getIntegerFrom(thisArg);
                dB.echoDebug("...quantity to check for is '%s'.", quantity.toString());
                continue;
            }
            if (aH.matchesValueArg("EXACTLY", thisArg, aH.ArgumentType.Integer)) {
                exactly = true;
                quantity = aH.getIntegerFrom(thisArg);
                dB.echoDebug("...will check for EXACT quantity.");
                continue;
            }
            dB.echoError("Could not match argument '%s'!", thisArg);
        }
        if (scriptCheck != null) {
            switch (1.$SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$ScriptRequirement$ScriptCheck[scriptCheck.ordinal()]) {
                case 1: {
                    Integer finishes = FinishCommand.getScriptCompletes(context.getPlayer().getName(), checkScript);
                    if (outcome) {
                        dB.echoDebug("...number of finishes is '%s'", finishes.toString());
                    }
                    if (quantity == null && finishes > 0) {
                        outcome = true;
                        break;
                    }
                    if (exactly) {
                        if (quantity != finishes) break;
                        outcome = true;
                        break;
                    }
                    if (finishes < quantity) break;
                    outcome = true;
                    break;
                }
                case 2: {
                    Integer fails = FailCommand.getScriptFails(context.getPlayer().getName(), checkScript);
                    if (outcome) {
                        dB.echoDebug("...number of fails is '%s'", fails.toString());
                    }
                    if (quantity == null && fails > 0) {
                        outcome = true;
                        break;
                    }
                    if (exactly) {
                        if (quantity != fails) break;
                        outcome = true;
                        break;
                    }
                    if (fails < quantity) break;
                    outcome = true;
                    break;
                }
                case 3: {
                    Integer currentStep = this.plugin.getSaves().getInt("Players." + context.getPlayer().getName() + "." + checkScript + "." + "Current Step", 0);
                    if (outcome) {
                        dB.echoDebug("...current step is '%s'", currentStep.toString());
                    }
                    if (step == null && currentStep > 0) {
                        outcome = true;
                        break;
                    }
                    if (exactly) {
                        if (step != currentStep) break;
                        outcome = true;
                        break;
                    }
                    if (currentStep < step) break;
                    outcome = true;
                }
            }
        }
        return outcome;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$ScriptRequirement$ScriptCheck;

        static {
            $SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$ScriptRequirement$ScriptCheck = new int[ScriptCheck.values().length];
            try {
                1.$SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$ScriptRequirement$ScriptCheck[ScriptCheck.FINISHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$ScriptRequirement$ScriptCheck[ScriptCheck.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$aufdemrand$denizen$scripts$requirements$core$ScriptRequirement$ScriptCheck[ScriptCheck.STEP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScriptCheck {
        FINISHED,
        FAILED,
        STEP;

    }
}

