/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.dScriptArgument;
import org.bukkit.configuration.ConfigurationSection;

public class Script
implements dScriptArgument {
    public static final Pattern matchesScriptPtrn = Pattern.compile("(?:.+:|)(.+)", 2);
    private String prefix = "Script";
    private String type = null;
    private String name = null;
    private boolean valid = false;

    public static Script valueOf(String string) {
        Script script;
        Matcher m = matchesScriptPtrn.matcher(string);
        if (m.matches() && (script = new Script(m.group(1))).isValid()) {
            return script;
        }
        return null;
    }

    public Script(String scriptName) {
        if (DenizenAPI.getCurrentInstance() == null) {
            return;
        }
        if (DenizenAPI.getCurrentInstance().getScripts().contains(scriptName.toUpperCase() + ".TYPE")) {
            this.name = scriptName.toUpperCase();
            this.type = DenizenAPI.getCurrentInstance().getScripts().getString(scriptName.toUpperCase() + ".TYPE");
            this.valid = true;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public ConfigurationSection getContents() {
        return DenizenAPI.getCurrentInstance().getScripts().getConfigurationSection(this.name);
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return "<G>" + this.prefix + "='<A>" + this.name + "<Y>(" + this.type + ")<G>'  ";
    }

    public String dScriptArg() {
        return this.prefix + ":" + this.name;
    }

    public String dScriptArgValue() {
        return this.name;
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

