/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.runnables.Runnable3;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ShootCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        EntityType entityType = null;
        Object qty = null;
        Location location = null;
        Boolean ride = false;
        Boolean burn = false;
        Boolean explode = false;
        Boolean fireworks = false;
        if (scriptEntry.getPlayer() != null) {
            location = new Location(scriptEntry.getPlayer().getLocation());
        }
        if (location == null && scriptEntry.getNPC() != null) {
            location = new Location(scriptEntry.getNPC().getLocation());
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesEntityType(arg)) {
                entityType = aH.getEntityFrom(arg);
                dB.echoDebug("...entity set to '%s'.", arg);
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set to '%s'.", arg);
                continue;
            }
            if (aH.matchesArg("RIDE, MOUNT", arg)) {
                ride = true;
                dB.echoDebug("...will be mounted.");
                continue;
            }
            if (aH.matchesArg("BURN, BURNING", arg)) {
                burn = true;
                dB.echoDebug("...will burn.");
                continue;
            }
            if (aH.matchesArg("EXPLODE, EXPLODING", arg)) {
                explode = true;
                dB.echoDebug("...will explode.");
                continue;
            }
            if (aH.matchesArg("FIREWORKS", arg)) {
                fireworks = true;
                dB.echoDebug("...will launch fireworks.");
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (entityType == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_INVALID_ENTITY);
        }
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("entityType", entityType);
        scriptEntry.addObject("ride", ride);
        scriptEntry.addObject("burn", burn);
        scriptEntry.addObject("explode", explode);
        scriptEntry.addObject("fireworks", fireworks);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location location = (Location)scriptEntry.getObject("location");
        EntityType entityType = (EntityType)scriptEntry.getObject("entityType");
        Boolean ride = (Boolean)scriptEntry.getObject("ride");
        Boolean burn = (Boolean)scriptEntry.getObject("burn");
        if (location == null) {
            location = (Location)scriptEntry.getNPC().getEyeLocation().getDirection().multiply(4).toLocation(scriptEntry.getNPC().getWorld());
        } else {
            Utilities.faceLocation((Entity)scriptEntry.getNPC().getCitizen().getBukkitEntity(), location);
        }
        Entity entity = scriptEntry.getNPC().getWorld().spawnEntity(scriptEntry.getNPC().getEyeLocation().add(scriptEntry.getNPC().getEyeLocation().getDirection()).subtract(0.0, 0.4, 0.0), entityType);
        Utilities.faceLocation(entity, location);
        if (ride.booleanValue()) {
            entity.setPassenger((Entity)scriptEntry.getPlayer());
        }
        if (burn.booleanValue()) {
            entity.setFireTicks(500);
        }
        if (entity instanceof Projectile) {
            ((Projectile)entity).setShooter(scriptEntry.getNPC().getCitizen().getBukkitEntity());
        }
        Runnable3<ScriptEntry, Entity, Location> task = new Runnable3<ScriptEntry, Entity, Location>(scriptEntry, entity, location){

            @Override
            public void run(ScriptEntry scriptEntry, Entity entity, Location location) {
                if (this.getRuns() < 40 && entity.isValid()) {
                    Vector v1 = entity.getLocation().toVector().clone();
                    Vector v2 = location.toVector().clone();
                    Vector v3 = v2.clone().subtract(v1).normalize().multiply(1.5);
                    entity.setVelocity(v3);
                    this.addRuns();
                    if (Math.abs(v2.getBlockX() - v1.getBlockX()) < 2 && Math.abs(v2.getBlockY() - v1.getBlockY()) < 2 && Math.abs(v2.getBlockZ() - v1.getBlockZ()) < 2) {
                        this.setRuns(40);
                    }
                } else {
                    this.cancel();
                    this.clearRuns();
                    if (((Boolean)scriptEntry.getObject("fireworks")).booleanValue()) {
                        Firework firework = (Firework)entity.getWorld().spawn(entity.getLocation(), Firework.class);
                        FireworkMeta fireworkMeta = firework.getFireworkMeta();
                        fireworkMeta.addEffects(new FireworkEffect[]{FireworkEffect.builder().withColor(Color.YELLOW).with(FireworkEffect.Type.STAR).build()});
                        fireworkMeta.setPower(2);
                        firework.setFireworkMeta(fireworkMeta);
                    }
                    if (((Boolean)scriptEntry.getObject("explode")).booleanValue()) {
                        entity.getWorld().createExplosion(entity.getLocation(), 4.0f);
                    }
                }
            }
        };
        task.setId(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.denizen, (Runnable)task, 0L, 2L));
    }
}

