/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class StrikeCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Location location = null;
        Boolean damage = true;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                continue;
            }
            if (aH.matchesArg("NO_DAMAGE, NODAMAGE", arg)) {
                damage = false;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (location == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
        }
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("damage", damage);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location location = (Location)scriptEntry.getObject("location");
        Boolean damage = (Boolean)scriptEntry.getObject("damage");
        dB.report(this.getName(), location.debug() + aH.debugObj("Damageable", String.valueOf(damage)));
        if (damage.booleanValue()) {
            location.getWorld().strikeLightning((org.bukkit.Location)location);
        } else {
            location.getWorld().strikeLightningEffect((org.bukkit.Location)location);
        }
    }
}

