/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Script;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.runnables.Runnable2;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ZapCommand
extends AbstractCommand
implements Listener {
    private static Map<String, Integer> durations = new ConcurrentHashMap<String, Integer>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Script script = scriptEntry.getScript();
        String step = null;
        Duration duration = new Duration(-1.0);
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesScript(arg)) {
                script = aH.getScriptFrom(arg);
                continue;
            }
            if (aH.matchesDuration(arg)) {
                duration = aH.getDurationFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("STEP", arg, aH.ArgumentType.String) || aH.matchesInteger(arg)) {
                step = aH.getStringFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_STEP, step);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("script", script);
        scriptEntry.addObject("step", step);
        scriptEntry.addObject("duration", duration);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Script script = (Script)scriptEntry.getObject("script");
        String step = (String)scriptEntry.getObject("step");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        String currentStep = this.denizen.getScriptEngine().getScriptHelper().getCurrentStep(scriptEntry.getPlayer(), script.getName(), false);
        if (step == null) {
            step = aH.matchesInteger(currentStep) ? String.valueOf(aH.getIntegerFrom(currentStep) + 1) : "1";
        }
        if (durations.containsKey(scriptEntry.getPlayer().getName() + "," + script.getName())) {
            try {
                this.denizen.getServer().getScheduler().cancelTask(durations.get(scriptEntry.getPlayer().getName() + "," + script.getName()).intValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (duration.getSeconds() > 0.0) {
            scriptEntry.addObject("step", currentStep);
            scriptEntry.addObject("duration", -1.0);
            long delay = (long)(duration.getSeconds() * 20.0);
            dB.echoDebug(dB.Messages.DEBUG_SETTING_DELAYED_TASK, "RESET ZAP for '" + script + "'");
            durations.put(scriptEntry.getPlayer().getName() + "," + script.getName(), this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, (Runnable)new Runnable2<String, ScriptEntry>(script.getName(), scriptEntry){

                @Override
                public void run(String script, ScriptEntry scriptEntry) {
                    block2: {
                        dB.log(dB.Messages.DEBUG_RUNNING_DELAYED_TASK, "RESET ZAP for '" + script + "'");
                        try {
                            durations.remove(scriptEntry.getPlayer().getName() + "," + script.toUpperCase());
                            ZapCommand.this.execute(scriptEntry);
                        }
                        catch (CommandExecutionException e) {
                            dB.echoError("Could not run delayed task!");
                            if (!dB.showStackTraces) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            }, delay));
        }
        this.denizen.getSaves().set("Players." + scriptEntry.getPlayer().getName() + ".Scripts." + script.getName().toUpperCase() + "." + "Current Step", (Object)step);
    }
}

