/*
 * Decompiled with CFR 0.152.
 */
package org.shade.abstractmeta.toolbox.compilation.compiler.impl;

import java.io.IOException;
import java.net.URI;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.shade.abstractmeta.toolbox.compilation.compiler.impl.JavaCodeFileObject;
import org.shade.abstractmeta.toolbox.compilation.compiler.registry.JavaFileObjectRegistry;
import org.shade.abstractmeta.toolbox.compilation.compiler.util.URIUtil;

public class SimpleJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final ClassLoader classLoader;
    private final JavaFileObjectRegistry javaFileObjectRegistry;

    protected SimpleJavaFileManager(JavaFileManager javaFileManager, ClassLoader classLoader, JavaFileObjectRegistry javaFileObjectRegistry) {
        super(javaFileManager);
        this.classLoader = classLoader;
        this.javaFileObjectRegistry = javaFileObjectRegistry;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        URI uri = URIUtil.buildUri(location, packageName, relativeName);
        if (this.javaFileObjectRegistry.isRegistered(uri)) {
            return this.javaFileObjectRegistry.get(uri);
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            JavaCodeFileObject result = new JavaCodeFileObject(URIUtil.buildUri(location, qualifiedName));
            this.javaFileObjectRegistry.register(result);
            return result;
        }
        throw new IllegalStateException(String.format("Unsupported kind: %s for %s", new Object[]{kind, qualifiedName}));
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }
}

