/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ChairCommand
extends AbstractCommand
implements Listener {
    public ConcurrentHashMap<NPC, Block> chairRegistry = new ConcurrentHashMap();

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Block chairBlock = null;
        ChairAction chairAction = ChairAction.SIT;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                chairBlock = aH.getLocationFrom(arg).getBlock();
                dB.echoDebug("...sit location set");
                continue;
            }
            if (aH.matchesValueArg("SIT, STAND", arg, aH.ArgumentType.Custom)) {
                chairAction = ChairAction.valueOf(aH.getStringFrom(arg));
                dB.echoDebug("...npc will " + chairAction.name());
                continue;
            }
            throw new InvalidArgumentsException("Invalid argument specified!");
        }
        scriptEntry.addObject("chairBlock", chairBlock);
        scriptEntry.addObject("chairAction", chairAction.name());
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Block chairBlock = (Block)scriptEntry.getObject("chairBlock");
        ChairAction chairAction = ChairAction.valueOf((String)scriptEntry.getObject("chairAction"));
        NPC npc = scriptEntry.getNPC().getCitizen();
        switch (chairAction) {
            case SIT: {
                if (this.isChair(chairBlock).booleanValue()) {
                    dB.echoError("...location is already being sat on!");
                    return;
                }
                if (this.isSitting(npc).booleanValue()) {
                    dB.echoError("...NPC is already sitting!");
                    return;
                }
                npc.getBukkitEntity().teleport(chairBlock.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                this.makeSit(npc, chairBlock);
                dB.echoError("...NPC sits!");
                break;
            }
            case STAND: {
                if (!this.isSitting(npc).booleanValue()) {
                    dB.echoError("...NPC is already standing!");
                    return;
                }
                this.makeStand(npc);
                dB.echoError("...NPC stands!");
            }
        }
    }

    public void makeSit(NPC npc, Block block) {
        try {
            PacketContainer entitymeta = ProtocolLibrary.getProtocolManager().createPacket(40);
            entitymeta.getSpecificModifier(Integer.TYPE).write(0, (Object)npc.getBukkitEntity().getEntityId());
            WrappedDataWatcher watcher = new WrappedDataWatcher();
            watcher.setObject(0, (Object)4);
            entitymeta.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
            for (Player player : this.denizen.getServer().getOnlinePlayers()) {
                if (!npc.getBukkitEntity().getWorld().equals(player.getWorld())) continue;
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, entitymeta);
                }
                catch (InvocationTargetException e) {
                    dB.echoError("...error sending packet to player: " + player.getName());
                }
            }
        }
        catch (Error e) {
            dB.echoError("ProtocolLib required for SIT command!!");
        }
        this.chairRegistry.put(npc, block);
    }

    public void makeStand(NPC npc) {
        try {
            PacketContainer entitymeta = ProtocolLibrary.getProtocolManager().createPacket(40);
            entitymeta.getSpecificModifier(Integer.TYPE).write(0, (Object)npc.getBukkitEntity().getEntityId());
            WrappedDataWatcher watcher = new WrappedDataWatcher();
            watcher.setObject(0, (Object)0);
            entitymeta.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
            for (Player player : this.denizen.getServer().getOnlinePlayers()) {
                if (!npc.getBukkitEntity().getWorld().equals(player.getWorld())) continue;
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, entitymeta);
                }
                catch (InvocationTargetException e) {
                    dB.echoError("...error sending packet to player: " + player.getName());
                }
            }
        }
        catch (Error e) {
            dB.echoError("ProtocolLib required for SIT command!!");
        }
        this.chairRegistry.remove(npc);
    }

    public Boolean isSitting(NPC npc) {
        if (this.chairRegistry.containsKey(npc)) {
            return true;
        }
        return false;
    }

    public Boolean isChair(Block block) {
        if (this.chairRegistry.containsValue(block)) {
            return true;
        }
        return false;
    }

    @EventHandler
    public void onNavigationBeginEvent(NavigationBeginEvent event) {
        if (this.isSitting(event.getNPC()).booleanValue()) {
            this.makeStand(event.getNPC());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.isChair(event.getBlock()).booleanValue()) {
            event.setCancelled(true);
            dB.echoDebug("..." + event.getPlayer().getName() + " tried to break an NPCs chair!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ChairAction {
        SIT,
        STAND;

    }
}

