/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.aufdemrand.denizen.notables.Notable;
import net.aufdemrand.denizen.npc.traits.ConstantsTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.util.Paginator;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AssignmentTrait
extends Trait {
    @Persist
    private String assignment = "";

    public void buildLocationContext() {
    }

    public AssignmentTrait() {
        super("assignment");
    }

    public void load(DataKey key) throws NPCLoadException {
        if (this.hasAssignment()) {
            dB.echoError("Missing assignment '" + this.assignment + "' for NPC '" + this.npc.getName() + "/" + this.npc.getId() + "! Perhaps the script has been removed?");
        }
    }

    public boolean setAssignment(String assignment, Player player) {
        if (this.checkAssignment(assignment)) {
            this.assignment = assignment.toUpperCase();
            if (!this.npc.hasTrait(ConstantsTrait.class)) {
                this.npc.addTrait(ConstantsTrait.class);
            }
            if (!this.npc.hasTrait(TriggerTrait.class)) {
                this.npc.addTrait(TriggerTrait.class);
            }
            ((ConstantsTrait)this.npc.getTrait(ConstantsTrait.class)).rebuildAssignmentConstants();
            DenizenAPI.getCurrentInstance().getNPCRegistry().getDenizen(this.npc).action("assignment", player);
            return true;
        }
        return false;
    }

    public String getAssignment() {
        if (this.hasAssignment()) {
            return this.assignment;
        }
        return null;
    }

    public boolean hasAssignment() {
        return this.checkAssignment(this.assignment);
    }

    public void removeAssignment(Player player) {
        this.assignment = "";
        DenizenAPI.getCurrentInstance().getNPCRegistry().getDenizen(this.npc).action("remove assignment", player);
    }

    private boolean checkAssignment(String assignment) {
        if (assignment == null || assignment.equals("")) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().getScriptEngine().getScriptHelper().getStringIgnoreCase(assignment + ".TYPE") != null && DenizenAPI.getCurrentInstance().getScriptEngine().getScriptHelper().getStringIgnoreCase(assignment + ".TYPE").equalsIgnoreCase("ASSIGNMENT");
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        ScriptHelper sH = DenizenAPI.getCurrentInstance().getScriptEngine().getScriptHelper();
        Paginator paginator = new Paginator().header("Assignment");
        paginator.addLine("<e>Current assignment: " + (this.hasAssignment() ? this.assignment : "None.") + "");
        paginator.addLine("");
        if (!this.hasAssignment()) {
            paginator.sendPage(sender, page);
            return;
        }
        boolean entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Interact Scripts:");
        paginator.addLine("<e>Key: <a>Priority  <b>Name");
        if (!sH.getStringListIgnoreCase(this.assignment + ".INTERACT SCRIPTS").isEmpty()) {
            entriesPresent = true;
            for (String scriptEntry : sH.getStringListIgnoreCase(this.assignment + ".INTERACT SCRIPTS")) {
                paginator.addLine("<a>" + scriptEntry.split(" ")[0] + "<b> " + scriptEntry.split(" ", 2)[1]);
            }
        }
        if (!entriesPresent) {
            paginator.addLine("<c>No Interact Scripts assigned.");
        }
        paginator.addLine("");
        if (!entriesPresent) {
            if (!paginator.sendPage(sender, page)) {
                throw new CommandException("citizens.commands.page-missing");
            }
            return;
        }
        entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Scheduled Scripts:");
        paginator.addLine("<e>Key: <a>Time  <b>Name");
        if (!sH.getStringListIgnoreCase(this.assignment + ".SCHEDULED ACTIVITIES").isEmpty()) {
            entriesPresent = true;
            for (String scriptEntry : sH.getStringListIgnoreCase(this.assignment + ".SCHEDULED ACTIVITIES")) {
                paginator.addLine("<a>" + scriptEntry.split(" ")[0] + "<b> " + scriptEntry.split(" ", 2)[1]);
            }
        }
        if (!entriesPresent) {
            paginator.addLine("<c>No scheduled scripts activities.");
        }
        paginator.addLine("");
        entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Linked Notable Locations:");
        paginator.addLine("<e>Key: <a>Name  <b>World  <c>Location");
        if (!DenizenAPI.getCurrentInstance().notableManager().getNotables().isEmpty()) {
            entriesPresent = true;
        }
        for (Notable notable : DenizenAPI.getCurrentInstance().notableManager().getNotables()) {
            if (!notable.hasLink(this.npc.getId())) continue;
            paginator.addLine(notable.describe());
        }
        if (!entriesPresent) {
            paginator.addLine("<c>No notable locations linked to this NPC.");
        }
        paginator.addLine("");
        entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Actions:");
        paginator.addLine("<e>Key: <a>Action name  <b>Script Size");
        if (DenizenAPI.getCurrentInstance().getScripts().contains(this.assignment.toUpperCase() + ".Actions")) {
            entriesPresent = true;
        }
        if (entriesPresent) {
            for (String action : DenizenAPI.getCurrentInstance().getScripts().getConfigurationSection(this.assignment.toUpperCase() + ".ACTIONS").getKeys(false)) {
                paginator.addLine("<a>" + action + " <b>" + sH.getStringListIgnoreCase(this.assignment + ".ACTIONS." + action).size());
            }
        } else {
            paginator.addLine("<c>No actions defined in the assignment.");
        }
        paginator.addLine("");
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }
}

