/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.events.dScriptReloadEvent;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.util.Paginator;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantsTrait
extends Trait {
    @Persist(value="", collectionType=ConcurrentHashMap.class)
    private Map<String, String> constants = new HashMap<String, String>();
    private Map<String, String> assignmentConstants = new HashMap<String, String>();
    private String assignment = null;

    public ConstantsTrait() {
        super("constants");
    }

    public String getConstant(String name) {
        this.getAssignmentConstants();
        if (this.constants.containsKey(name.toLowerCase())) {
            return DenizenAPI.getCurrentInstance().tagManager().tag(null, DenizenAPI.getDenizenNPC(this.npc), this.constants.get(name.toLowerCase()), false);
        }
        if (this.getAssignmentConstants().containsKey(name.toLowerCase())) {
            return DenizenAPI.getCurrentInstance().tagManager().tag(null, DenizenAPI.getDenizenNPC(this.npc), this.assignmentConstants.get(name.toLowerCase()), false);
        }
        return null;
    }

    public Map<String, String> getNPCConstants() {
        return this.constants;
    }

    public Map<String, String> getAllConstants() {
        HashMap<String, String> allConstants = new HashMap<String, String>();
        this.getAssignmentConstants().putAll(allConstants);
        this.getNPCConstants().putAll(allConstants);
        return allConstants;
    }

    public void setConstant(String name, String value) {
        this.constants.put(name.toLowerCase(), value);
    }

    public void removeConstant(String name) {
        if (this.constants.containsKey(name.toLowerCase())) {
            this.constants.remove(name.toLowerCase());
        }
    }

    public boolean hasNPCConstants() {
        return !this.constants.isEmpty();
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        Paginator paginator = new Paginator().header("Constants for " + this.npc.getName());
        paginator.addLine("<e>NPC-specific constants: " + (this.hasNPCConstants() ? "" : "None.") + "");
        if (this.hasNPCConstants()) {
            paginator.addLine("<e>Key: <a>Name  <b>Value");
        }
        for (Map.Entry<String, String> constant : this.constants.entrySet()) {
            paginator.addLine("<a> " + String.valueOf(constant.getKey().charAt(0)).toUpperCase() + constant.getKey().substring(1) + "<b>  " + constant.getValue());
        }
        paginator.addLine("");
        if (this.npc.hasTrait(AssignmentTrait.class) && ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).hasAssignment()) {
            this.getAssignmentConstants();
            paginator.addLine("<e>Constants for assignment '" + this.assignment.toUpperCase() + "':");
            paginator.addLine("<e>Key: <a>Name  <b>Value");
            for (Map.Entry<String, String> constant : this.getAssignmentConstants().entrySet()) {
                if (this.constants.containsKey(constant.getKey())) {
                    paginator.addLine("<m>" + String.valueOf(constant.getKey().charAt(0)).toUpperCase() + constant.getKey().substring(1) + "<r>  <m>" + constant.getValue());
                    continue;
                }
                paginator.addLine("<a>" + String.valueOf(constant.getKey().charAt(0)).toUpperCase() + constant.getKey().substring(1) + "<b>  " + constant.getValue());
            }
            paginator.addLine("");
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }

    public Map<String, String> getAssignmentConstants() {
        if (this.npc.hasTrait(AssignmentTrait.class) && ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).hasAssignment()) {
            if (this.assignment != null && this.assignment.equalsIgnoreCase(((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).getAssignment())) {
                return this.assignmentConstants;
            }
            return this.rebuildAssignmentConstants();
        }
        return this.assignmentConstants;
    }

    public Map<String, String> rebuildAssignmentConstants() {
        if (!this.npc.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).hasAssignment()) {
            this.assignmentConstants.clear();
            return this.assignmentConstants;
        }
        this.assignment = ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).getAssignment();
        this.assignmentConstants.clear();
        if (DenizenAPI.getCurrentInstance().getScripts().contains(this.assignment.toUpperCase() + ".DEFAULT CONSTANTS")) {
            for (String constant : DenizenAPI.getCurrentInstance().getScripts().getConfigurationSection(this.assignment.toUpperCase() + ".DEFAULT CONSTANTS").getKeys(false)) {
                this.assignmentConstants.put(constant.toLowerCase(), DenizenAPI.getCurrentInstance().getScripts().getString(this.assignment.toUpperCase() + ".DEFAULT CONSTANTS." + constant.toUpperCase(), ""));
            }
        }
        return this.assignmentConstants;
    }

    @EventHandler
    public void onScriptsReload(dScriptReloadEvent event) {
        this.rebuildAssignmentConstants();
    }
}

