/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizen.scripts.ScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ActivityScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.AssignmentScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.EntityScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.configuration.ConfigurationSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptRegistry {
    private static Map<String, ScriptContainer> scriptContainers = new HashMap<String, ScriptContainer>();
    private static Map<String, Class<? extends ScriptContainer>> scriptContainerTypes = new HashMap<String, Class<? extends ScriptContainer>>();

    public static void registerCoreTypes() {
        ScriptRegistry.registerType("interact", InteractScriptContainer.class);
        ScriptRegistry.registerType("book", BookScriptContainer.class);
        ScriptRegistry.registerType("item", ItemScriptContainer.class);
        ScriptRegistry.registerType("entity", EntityScriptContainer.class);
        ScriptRegistry.registerType("task", TaskScriptContainer.class);
        ScriptRegistry.registerType("activity", ActivityScriptContainer.class);
        ScriptRegistry.registerType("assignment", AssignmentScriptContainer.class);
    }

    public static void registerType(String typeName, Class<? extends ScriptContainer> scriptContainerClass) {
        scriptContainerTypes.put(typeName.toUpperCase(), scriptContainerClass);
    }

    public static void _buildCoreScripts() {
        Set scripts = DenizenAPI.getCurrentInstance().getScripts().getKeys(false);
        for (String scriptName : scripts) {
            String type;
            if (!DenizenAPI.getCurrentInstance().getScripts().contains(scriptName + ".TYPE") || (type = DenizenAPI.getCurrentInstance().getScripts().getString(scriptName + ".TYPE")) == null) continue;
            dB.log("<G>Trying to load an invalid script. '<T>" + scriptName + "<Y>(" + type + ")'<G> is an unknown type.");
            scriptContainers.put(scriptName.toUpperCase(), new ScriptContainer(scriptName));
        }
    }

    public static void _buildScripts(ConfigurationSection configurationSection) {
    }

    public static <T extends ScriptContainer> T getScriptContainer(String scriptContainerName) {
        try {
            return (T)((Object)scriptContainerTypes.get((Object)scriptContainers.get(scriptContainerName.toUpperCase())).getConstructor(scriptContainerTypes.get((Object)scriptContainers.get(scriptContainerName.toUpperCase()))).newInstance(scriptContainerName.toUpperCase()));
        }
        catch (Exception e) {
            return null;
        }
    }
}

