/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class WaitCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (scriptEntry.getSendingQueue() == null) {
            throw new InvalidArgumentsException("WAIT can only be used with a queue!");
        }
        if (scriptEntry.getAllowedRunTime() > scriptEntry.getQueueTime()) {
            aH.debugObj("Held Queue", scriptEntry.getSendingQueue().toString() + (scriptEntry.getPlayer() != null && (scriptEntry.getSendingQueue() == ScriptEngine.QueueType.PLAYER || scriptEntry.getSendingQueue() == ScriptEngine.QueueType.PLAYER_TASK) ? aH.debugObj("Player", scriptEntry.getPlayer().getName()) : "") + (scriptEntry.getNPC() != null && scriptEntry.getSendingQueue() == ScriptEngine.QueueType.NPC ? aH.debugObj("NPC", scriptEntry.getNPC().toString()) : ""));
            return;
        }
        ScriptEngine.QueueType queueToHold = scriptEntry.getSendingQueue();
        scriptEntry.setInstant(true);
        Duration delay = new Duration(5.0);
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesInteger(arg) || aH.matchesDuration(arg)) {
                delay = Duration.valueOf(arg);
            }
            if (!aH.matchesQueueType(arg)) continue;
            queueToHold = aH.getQueueFrom(arg);
        }
        scriptEntry.addObject("queue", (Object)queueToHold);
        scriptEntry.addObject("delay", delay.setPrefix("Duration"));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        if (scriptEntry.getAllowedRunTime() > scriptEntry.getQueueTime()) {
            return;
        }
        dB.echoDebug("Holding...");
        ScriptEngine.QueueType queue = (ScriptEngine.QueueType)((Object)scriptEntry.getObject("queue"));
        Duration delay = (Duration)scriptEntry.getObject("delay");
        ArrayList<ScriptEntry> list = new ArrayList<ScriptEntry>();
        try {
            scriptEntry.setAllowedRunTime(System.currentTimeMillis() + (long)(delay.getSeconds() * 1000.0));
            list.add(scriptEntry);
            if (queue == ScriptEngine.QueueType.PLAYER_TASK) {
                this.denizen.getScriptEngine().injectToQueue(scriptEntry.getPlayer(), list, ScriptEngine.QueueType.PLAYER_TASK, 0);
            } else if (queue == ScriptEngine.QueueType.PLAYER) {
                this.denizen.getScriptEngine().injectToQueue(scriptEntry.getPlayer(), list, ScriptEngine.QueueType.PLAYER, 0);
            } else if (queue == ScriptEngine.QueueType.NPC) {
                this.denizen.getScriptEngine().injectToQueue(scriptEntry.getNPC(), list, ScriptEngine.QueueType.NPC, 0);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

