/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements;

import java.util.ArrayList;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.exceptions.RequirementCheckException;
import net.aufdemrand.denizen.scripts.requirements.AbstractRequirement;
import net.aufdemrand.denizen.scripts.requirements.RequirementsContext;
import net.aufdemrand.denizen.scripts.requirements.RequirementsMode;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;

public class RequirementChecker {
    private Denizen plugin;

    public RequirementChecker(Denizen denizen) {
        this.plugin = denizen;
    }

    public boolean check(RequirementsContext context) {
        if (context.mode.getMode() == RequirementsMode.Mode.NONE || context.list.isEmpty()) {
            return true;
        }
        dB.echoDebug(ChatColor.YELLOW + "CHECK! Now checking '%s'", context.scriptName);
        dB.echoDebug("Requirement mode: '%s'", context.mode.getMode().toString());
        boolean firstReqMet = false;
        boolean firstReqChecked = false;
        int numberMet = 0;
        for (String reqEntry : context.list) {
            boolean negativeRequirement = false;
            if (reqEntry.startsWith("-")) {
                negativeRequirement = true;
                reqEntry = reqEntry.substring(1);
            }
            if (this.plugin.getRequirementRegistry().list().containsKey(reqEntry.split(" ")[0].toUpperCase())) {
                AbstractRequirement requirement = this.plugin.getRequirementRegistry().get(reqEntry.split(" ")[0].toUpperCase());
                String[] arguments = null;
                if (reqEntry.split(" ").length > 1) {
                    arguments = this.plugin.getScriptEngine().getScriptBuilder().buildArgs(reqEntry.split(" ", 2)[1]);
                }
                ArrayList<String> argumentList = new ArrayList();
                if (arguments != null) {
                    argumentList = this.plugin.tagManager().fillArguments(arguments, context.player, this.plugin.getNPCRegistry().getDenizen(context.npc));
                }
                try {
                    int numArguments;
                    int n = numArguments = arguments == null ? 0 : arguments.length;
                    if (numArguments == 0 && requirement.requirementOptions.REQUIRED_ARGS > 0 || numArguments < requirement.requirementOptions.REQUIRED_ARGS) {
                        throw new RequirementCheckException("");
                    }
                    if (requirement.check(context, argumentList) != negativeRequirement) {
                        if (!firstReqChecked) {
                            firstReqMet = true;
                            firstReqChecked = true;
                        }
                        ++numberMet;
                        dB.echoApproval("Checking Requirement '" + requirement.getName() + "'" + " ...requirement met!");
                        continue;
                    }
                    if (!firstReqChecked) {
                        firstReqMet = false;
                        firstReqChecked = true;
                    }
                    dB.echoApproval("Checking Requirement '" + requirement.getName() + "'" + " ...requirement not met!");
                }
                catch (Throwable e) {
                    if (e instanceof RequirementCheckException) {
                        dB.echoError("Woah! Invalid arguments were specified!");
                        dB.echoError("Usage: " + requirement.getUsageHint());
                        continue;
                    }
                    dB.echoError("Woah! An exception has been called for Requirement '" + requirement.getName() + "'!");
                    if (!dB.showStackTraces) {
                        dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                        continue;
                    }
                    e.printStackTrace();
                }
                continue;
            }
            dB.echoError("Requirement '" + reqEntry.split(" ")[0] + "' not found! Check that the requirement is installed!");
        }
        if (context.mode.getMode() == RequirementsMode.Mode.ALL && numberMet == context.list.size()) {
            return true;
        }
        if (context.mode.getMode() == RequirementsMode.Mode.ANY_NUM) {
            return numberMet >= context.mode.modeInt;
        }
        if (context.mode.getMode() == RequirementsMode.Mode.FIRST_AND_ANY_NUM) {
            if (firstReqMet) {
                return numberMet > context.mode.modeInt;
            }
            return false;
        }
        return false;
    }
}

