/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationTrigger
extends AbstractTrigger
implements Listener {
    private Map<Trigger, LocationContext> locationTriggers = new ConcurrentHashMap<Trigger, LocationContext>();

    public void addLocation(Location location, NPC npc, String scriptName, String stepName, int radius, String locationName) {
        this.locationTriggers.put(new Trigger(location), new LocationContext(npc.getId(), radius, scriptName, stepName, locationName));
    }

    public void clearTriggers() {
        this.locationTriggers.clear();
    }

    public int maximumLocationDistanceSetting() {
        return 10;
    }

    @EventHandler
    public void checkLocation(PlayerMoveEvent event) {
        if (event.getFrom().getBlock() == event.getTo().getBlock()) {
            return;
        }
        Set<NPC> matchingNPCs = this.checkLocation(event.getPlayer().getLocation());
        if (matchingNPCs.size() > 0) {
            ArrayList<InteractContext> interactContext = new ArrayList<InteractContext>();
            for (NPC npc : matchingNPCs) {
                String interactScript = this.sH.getInteractScript(npc, event.getPlayer(), this.getClass());
                if (interactScript == null) continue;
                String step = this.denizen.getScriptEngine().getScriptHelper().getCurrentStep(event.getPlayer(), interactScript, false);
                interactContext.add(new InteractContext(npc, interactScript, step));
            }
            for (InteractContext ics : interactContext) {
            }
        }
    }

    public Set<NPC> checkLocation(Location location) {
        ArrayList<Trigger> matchingTriggers = new ArrayList<Trigger>();
        HashSet<NPC> matchingNPCs = new HashSet<NPC>();
        for (Trigger trigger : this.locationTriggers.keySet()) {
            NPC npc;
            if (!trigger.matches(location) || !(npc = CitizensAPI.getNPCRegistry().getById(this.locationTriggers.get(trigger).npcid)).hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getTrait(TriggerTrait.class)).isEnabled(this.name)) continue;
            matchingNPCs.add(npc);
            matchingTriggers.add(trigger);
        }
        return matchingNPCs;
    }

    @Override
    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    private class InteractContext {
        private String scriptName;
        private String stepName;
        private int npcid;

        public InteractContext(NPC npc, String scriptName, String stepName) {
            this.npcid = npc.getId();
            this.scriptName = scriptName;
            this.stepName = stepName;
        }
    }

    private class LocationContext {
        private String scriptName;
        private String stepName;
        private String locationName;
        private int radius;
        private int npcid;

        public LocationContext(int npcid, int radius, String scriptName, String stepName, String locationName) {
            this.scriptName = scriptName;
            this.stepName = stepName;
            this.locationName = locationName;
            this.npcid = npcid;
        }

        public int getRadius() {
            return this.radius;
        }

        public String getPath() {
            return this.scriptName + ".steps." + this.stepName + ".location trigger." + this.locationName + ".script";
        }

        public boolean matches(InteractContext interactContext) {
            if (interactContext.npcid != this.npcid) {
                return false;
            }
            if (!interactContext.scriptName.equalsIgnoreCase(this.scriptName)) {
                return false;
            }
            return interactContext.stepName.equalsIgnoreCase(this.stepName);
        }
    }

    private class Trigger {
        private int x;
        private int y;
        private int z;
        private String world;

        public Trigger(Location location) {
            this.x = location.getBlockX();
            this.y = location.getBlockY();
            this.z = location.getBlockZ();
            this.world = location.getWorld().getName();
        }

        public boolean matches(Location location) {
            if (Math.abs(location.getBlockX() - this.x) > LocationTrigger.this.maximumLocationDistanceSetting()) {
                return false;
            }
            if (Math.abs(location.getBlockY() - this.y) > LocationTrigger.this.maximumLocationDistanceSetting()) {
                return false;
            }
            if (Math.abs(location.getBlockZ() - this.z) > LocationTrigger.this.maximumLocationDistanceSetting()) {
                return false;
            }
            return location.getWorld().getName().equals(this.world);
        }

        public int getDistance(Player player) {
            return 0;
        }
    }
}

