/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class AnnounceCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String text = null;
        if (scriptEntry.getArguments().size() > 3) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_LOTS_OF_ARGUMENTS);
        }
        for (String arg : scriptEntry.getArguments()) {
            text = aH.getStringFrom(arg);
        }
        if (text == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_TEXT);
        }
        scriptEntry.addObject("text", text);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String text = (String)scriptEntry.getObject("text");
        dB.report(this.getName(), aH.debugObj("Message", text));
        this.denizen.getServer().broadcastMessage(text);
    }
}

