/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractScriptContainer
extends ScriptContainer {
    private String defaultStep;
    private List<String> steps = new ArrayList<String>();

    public InteractScriptContainer(ConfigurationSection configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        try {
            for (String step : this.getConfigurationSection("STEPS").getKeys(false)) {
                if (step.contains("*")) {
                    ConfigurationSection defaultStepSection = this.getConfigurationSection("STEPS." + step);
                    step = step.replace("*", "");
                    this.set("STEPS." + step, defaultStepSection);
                    this.set("STEPS." + step + "*", null);
                    this.defaultStep = step;
                }
                if (step.equalsIgnoreCase("1")) {
                    this.defaultStep = step;
                }
                if (step.equalsIgnoreCase("DEFAULT")) {
                    this.defaultStep = step;
                }
                this.steps.add(step);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getStepNames() {
        return this.steps;
    }

    public String getDefaultStepName() {
        return this.defaultStep;
    }

    public boolean containsTriggerInStep(String step, Class<? extends AbstractTrigger> trigger) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        return this.contains("STEPS." + step.toUpperCase() + "." + triggerName + " TRIGGER");
    }

    public List<ScriptEntry> getEntriesFor(Class<? extends AbstractTrigger> trigger, Player player, dNPC npc, String id) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        if (this.contains("STEPS." + InteractScriptHelper.getCurrentStep(player, this.getName()) + "." + triggerName + " TRIGGER." + (id == null ? "SCRIPT" : id.toUpperCase() + ".SCRIPT"))) {
            return this.getEntries(player, npc, "STEPS." + InteractScriptHelper.getCurrentStep(player, this.getName()) + "." + triggerName + " TRIGGER." + (id == null ? "SCRIPT" : id.toUpperCase() + ".SCRIPT"));
        }
        return Collections.emptyList();
    }

    public Map<String, String> getIdMapFor(Class<? extends AbstractTrigger> trigger, Player player) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        if (this.contains("STEPS." + step + "." + triggerName + " TRIGGER")) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            for (String id : this.getConfigurationSection("STEPS." + step + "." + triggerName + " TRIGGER").getKeys(false)) {
                if (id.equalsIgnoreCase("SCRIPT")) continue;
                idMap.put(id, this.getString("STEPS." + step + "." + triggerName + " TRIGGER." + id + ".TRIGGER", ""));
            }
            return idMap;
        }
        return Collections.emptyMap();
    }

    public boolean checkSpecificTriggerScriptRequirementsFor(Class<? extends AbstractTrigger> trigger, Player player, dNPC npc, String id) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        return this.checkRequirements(player, npc, "STEPS." + step + "." + triggerName + " TRIGGER" + (id == null ? "" : "." + id.toUpperCase()));
    }

    public String getTriggerOptionFor(Class<? extends AbstractTrigger> trigger, Player player, String id, String option) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        return this.getString("STEPS." + step + "." + triggerName + " TRIGGER" + (id == null ? "" : "." + id.toUpperCase()) + "." + option.toUpperCase());
    }

    public boolean hasTriggerOptionFor(Class<? extends AbstractTrigger> trigger, Player player, String id, String option) {
        String triggerName = DenizenAPI.getCurrentInstance().getTriggerRegistry().get(trigger).getName().toUpperCase();
        String step = InteractScriptHelper.getCurrentStep(player, this.getName());
        return this.contains("STEPS." + step + "." + triggerName + " TRIGGER" + (id == null ? "" : "." + id.toUpperCase()) + "." + option.toUpperCase());
    }
}

