/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.arguments;

import com.google.common.primitives.Ints;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.utilities.arguments.dScriptArgument;

public class Duration
implements dScriptArgument {
    static final Pattern matchesDurationPtrn = Pattern.compile("(?:.+:|)(\\d+(?:(|\\.\\d+)))(|t|m|s|h|d)", 2);
    private double seconds;
    private String prefix = "Duration";

    public static Duration valueOf(String string) {
        Matcher m = matchesDurationPtrn.matcher(string);
        if (m.matches()) {
            if (m.group().toUpperCase().endsWith("T")) {
                return new Duration(Double.valueOf(m.group(1)) * 0.05);
            }
            if (m.group().toUpperCase().endsWith("D")) {
                return new Duration(Double.valueOf(m.group(1)) * 86400.0);
            }
            if (m.group().toUpperCase().endsWith("M")) {
                return new Duration(Double.valueOf(m.group(1)) * 60.0);
            }
            if (m.group().toUpperCase().endsWith("H")) {
                return new Duration(Double.valueOf(m.group(1)) * 3600.0);
            }
            return new Duration(Double.valueOf(m.group(1)));
        }
        return null;
    }

    public Duration(double seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public Duration(int seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public Duration(long ticks) {
        this.seconds = ticks / 20L;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public long getTicks() {
        return (long)(this.seconds * 20.0);
    }

    public int getTicksAsInt() {
        return Ints.checkedCast((long)((long)(this.seconds * 20.0)));
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getSecondsAsInt() {
        if (this.seconds < 1.0 && this.seconds > 0.0) {
            return 1;
        }
        return Ints.checkedCast((long)Math.round(this.seconds));
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.seconds + " seconds<G>'  ";
    }

    public String dScriptArg() {
        return this.prefix + ":" + this.seconds;
    }

    public String dScriptArgValue() {
        return String.valueOf(this.seconds);
    }

    public dScriptArgument setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

