/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.utilities.arguments.Script;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEntry {
    private String command;
    private long creationTime;
    private long queueTime;
    private long runTime;
    private long holdTime;
    private boolean instant = false;
    private Player player = null;
    private OfflinePlayer offlinePlayer = null;
    private dNPC npc = null;
    private Script script = null;
    private String queueId = null;
    private List<String> args = null;
    private Map<String, Object> objects = new HashMap<String, Object>();

    public ScriptEntry(String command, String[] arguments, ScriptContainer script) throws ScriptEntryCreationException {
        if (command == null) {
            throw new ScriptEntryCreationException("CommandType cannot be null!");
        }
        this.command = command.toUpperCase();
        this.script = script.getAsScriptArg();
        this.queueTime = this.creationTime = System.currentTimeMillis();
        this.runTime = this.creationTime;
        this.holdTime = this.creationTime;
        if (command.startsWith("^")) {
            this.instant = true;
            this.command = command.substring(1);
        }
        this.args = new ArrayList<String>();
        if (arguments != null) {
            this.args = Arrays.asList(arguments);
        }
    }

    public ScriptEntry addObject(String key, Object object) {
        if (object == null) {
            return this;
        }
        this.objects.put(key.toUpperCase(), object);
        return this;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public long getHoldTime() {
        return this.holdTime;
    }

    public List<String> getArguments() {
        return this.args;
    }

    public String getCommandName() {
        return this.command;
    }

    public dNPC getNPC() {
        return this.npc;
    }

    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public ScriptEntry setOfflinePlayer(OfflinePlayer offlinePlayer) {
        this.offlinePlayer = offlinePlayer;
        return this;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    public Object getObject(String key) {
        try {
            return this.objects.get(key.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasObject(String key) {
        return this.objects.containsKey(key.toUpperCase());
    }

    public Script getScript() {
        return this.script;
    }

    public String getResidingQueue() {
        return this.queueId;
    }

    public Long getQueueTime() {
        return this.queueTime;
    }

    public boolean isInstant() {
        return this.instant;
    }

    public ScriptEntry setRunTime(Long newTime) {
        this.runTime = newTime;
        return this;
    }

    public ScriptEntry setArguments(List<String> arguments) {
        this.args = arguments;
        return this;
    }

    public ScriptEntry setInstant(boolean instant) {
        this.instant = instant;
        return this;
    }

    public ScriptEntry setPlayer(Player player) {
        this.player = player;
        return this;
    }

    public ScriptEntry setNPC(dNPC dNPC2) {
        this.npc = dNPC2;
        return this;
    }

    public ScriptEntry setScript(String scriptName) {
        this.script = Script.valueOf(scriptName);
        return this;
    }

    public void setSendingQueue(ScriptQueue scriptQueue) {
        this.queueId = scriptQueue.id;
    }
}

