/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Script;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;

public class RuntaskCommand
extends AbstractCommand
implements Listener {
    private static Map<String, Integer> delays = new ConcurrentHashMap<String, Integer>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Script script = null;
        HashMap<String, String> context = null;
        Duration delay = new Duration(0);
        Duration speed = new Duration((long)Settings.InteractDelayInTicks());
        ScriptQueue queue = ScriptQueue._getQueue(ScriptQueue._getNextId());
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesScript(arg)) {
                script = aH.getScriptFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("DELAY", arg, aH.ArgumentType.Duration)) {
                delay = aH.getDurationFrom(arg);
                delay.setPrefix("Delay");
                continue;
            }
            if (aH.matchesQueue(arg)) {
                queue = aH.getQueueFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("SPEED", arg, aH.ArgumentType.Duration)) {
                speed = aH.getDurationFrom(arg);
                continue;
            }
            if (aH.matchesArg("QUEUE", arg) || aH.matchesArg("INSTANT, INSTANTLY", arg)) continue;
            if (aH.matchesValueArg("CONTEXT", arg, aH.ArgumentType.Custom)) {
                context = new HashMap<String, String>();
                List<String> contexts = aH.getListFrom(arg);
                for (String ctxt : contexts) {
                    String[] sctxt = ctxt.split(",", 2);
                    if (sctxt.length > 1) {
                        context.put(sctxt[0].trim().toUpperCase(), sctxt[1].trim());
                        continue;
                    }
                    context.put(sctxt[0].trim().toUpperCase(), "true");
                }
                continue;
            }
            if (aH.matchesValueArg("ID", arg, aH.ArgumentType.Word)) continue;
            if (ScriptRegistry.containsScript(aH.getStringFrom(arg))) {
                script = aH.getScriptFrom(arg);
                if (script.getType().equalsIgnoreCase("TASK")) continue;
                script = null;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (script == null) {
            throw new InvalidArgumentsException("Must define a script to be run!");
        }
        scriptEntry.addObject("speed", speed);
        scriptEntry.addObject("queue", queue);
        scriptEntry.addObject("delay", delay.setPrefix("Delay"));
        scriptEntry.addObject("script", script);
        scriptEntry.addObject("context", context);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        HashMap context = (HashMap)scriptEntry.getObject("context");
        Script script = (Script)scriptEntry.getObject("script");
        ScriptQueue queue = (ScriptQueue)scriptEntry.getObject("queue");
        Duration speed = (Duration)scriptEntry.getObject("speed");
        Duration delay = (Duration)scriptEntry.getObject("delay");
        dB.echoApproval("Executing '" + this.getName() + "': " + script.debug() + delay.debug() + "Queue='" + queue.toString());
        if (delay.getSeconds() <= 0.0) {
            ((TaskScriptContainer)script.getContainer()).setSpeed(speed).runTaskScript(queue.id, scriptEntry.getPlayer(), scriptEntry.getNPC(), context);
        } else {
            ((TaskScriptContainer)script.getContainer()).setSpeed(speed).runTaskScriptWithDelay(queue.id, scriptEntry.getPlayer(), scriptEntry.getNPC(), context, delay);
        }
    }

    public static boolean cancelTask(String id) {
        if (delays.containsKey(id.toUpperCase())) {
            block3: {
                try {
                    Bukkit.getServer().getScheduler().cancelTask(delays.get(id.toUpperCase()).intValue());
                }
                catch (Exception e) {
                    dB.echoError("Could not cancel task!");
                    if (!dB.showStackTraces) break block3;
                    e.printStackTrace();
                }
            }
            delays.remove(id.toUpperCase());
            return true;
        }
        return false;
    }
}

