/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.runnables.Runnable2;
import net.citizensnpcs.trait.waypoint.Waypoints;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PauseCommand
extends AbstractCommand {
    private Map<String, Integer> durations = new ConcurrentHashMap<String, Integer>();
    int duration;
    PauseType pauseType;
    dNPC dNPC;
    Player player;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.duration = -1;
        this.pauseType = null;
        this.dNPC = null;
        this.player = null;
        if (scriptEntry.getNPC() != null) {
            this.dNPC = scriptEntry.getNPC();
        }
        if (scriptEntry.getPlayer() != null) {
            this.player = scriptEntry.getPlayer();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                this.duration = aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_DURATION, arg);
                continue;
            }
            if (aH.matchesArg("WAYPOINTS", arg) || aH.matchesArg("NAVIGATION", arg) || aH.matchesArg("ACTIVITY", arg) || aH.matchesArg("WAYPOINTS", arg)) {
                this.pauseType = PauseType.valueOf(arg.toUpperCase());
                dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        this.pause(this.dNPC, this.pauseType, !scriptEntry.getCommandName().equalsIgnoreCase("RESUME"));
        if (this.duration > 0) {
            if (this.durations.containsKey(this.dNPC.getCitizen().getId() + this.pauseType.name())) {
                try {
                    this.denizen.getServer().getScheduler().cancelTask(this.durations.get(this.dNPC.getCitizen().getId() + this.pauseType.name()).intValue());
                }
                catch (Exception e) {
                    dB.echoError(dB.Messages.ERROR_CANCELLING_DELAYED_TASK);
                }
            }
            dB.echoDebug(dB.Messages.DEBUG_SETTING_DELAYED_TASK, "UNPAUSE " + (Object)((Object)this.pauseType));
            this.durations.put(this.dNPC.getId() + this.pauseType.name(), this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, (Runnable)new Runnable2<dNPC, PauseType>(this.dNPC, this.pauseType){

                @Override
                public void run(dNPC npc, PauseType type) {
                    dB.echoDebug(dB.Messages.DEBUG_RUNNING_DELAYED_TASK, "UNPAUSING " + (Object)((Object)PauseCommand.this.pauseType));
                    PauseCommand.this.pause(npc, type, false);
                }
            }, (long)(this.duration * 20)));
        }
    }

    public void pause(dNPC denizen, PauseType pauseType, boolean pause) {
        switch (pauseType) {
            case WAYPOINTS: {
                ((Waypoints)denizen.getCitizen().getTrait(Waypoints.class)).getCurrentProvider().setPaused(pause);
                if (pause) {
                    denizen.getNavigator().cancelNavigation();
                }
                return;
            }
            case ACTIVITY: {
                denizen.getCitizen().getDefaultGoalController().setPaused(pause);
                return;
            }
        }
    }

    public void onEnable() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PauseType {
        ACTIVITY,
        WAYPOINTS,
        NAVIGATION;

    }
}

