/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.tags.core.AnchorTags;
import net.aufdemrand.denizen.tags.core.BookmarkTags;
import net.aufdemrand.denizen.tags.core.ColorTags;
import net.aufdemrand.denizen.tags.core.ConstantTags;
import net.aufdemrand.denizen.tags.core.ContextTags;
import net.aufdemrand.denizen.tags.core.FlagTags;
import net.aufdemrand.denizen.tags.core.LocationTags;
import net.aufdemrand.denizen.tags.core.NPCTags;
import net.aufdemrand.denizen.tags.core.OfflinePlayerTags;
import net.aufdemrand.denizen.tags.core.PlayerTags;
import net.aufdemrand.denizen.tags.core.SpecialCharacterTags;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagManager {
    public Denizen denizen;
    private static Pattern tagRegex = Pattern.compile("<([^<>]+)>");

    public TagManager(Denizen denizen) {
        this.denizen = denizen;
    }

    public void registerCoreTags() {
        new PlayerTags(this.denizen);
        new OfflinePlayerTags(this.denizen);
        new ColorTags(this.denizen);
        new FlagTags(this.denizen);
        new BookmarkTags(this.denizen);
        new ConstantTags(this.denizen);
        new NPCTags(this.denizen);
        new AnchorTags(this.denizen);
        new ContextTags(this.denizen);
        new LocationTags(this.denizen);
        new SpecialCharacterTags(this.denizen);
    }

    public String tag(OfflinePlayer player, dNPC npc, String arg, boolean instant) {
        return this.tag(player, npc, arg, instant, null);
    }

    public String tag(OfflinePlayer player, dNPC npc, String arg, boolean instant, ScriptEntry scriptEntry) {
        if (arg == null) {
            return null;
        }
        if (arg.indexOf(62) == -1 || arg.length() < 3) {
            return arg;
        }
        int[] positions = this.locateTag(arg);
        if (positions == null) {
            return arg;
        }
        boolean changeBack = false;
        int failsafe = 0;
        do {
            ++failsafe;
            if (positions == null) break;
            ReplaceableTagEvent event = new ReplaceableTagEvent(player, npc, arg.substring(positions[0] + 1, positions[1]), scriptEntry);
            if (event.isInstant() != instant) {
                changeBack = true;
                arg = arg.substring(0, positions[0]) + "{" + event.getReplaced() + "}" + arg.substring(positions[1] + 1, arg.length());
                continue;
            }
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (!event.replaced() && event.getAlternative() != null) {
                event.setReplaced(event.getAlternative());
            }
            arg = arg.substring(0, positions[0]) + event.getReplaced() + arg.substring(positions[1] + 1, arg.length());
        } while ((positions = this.locateTag(arg)) != null || failsafe < 25);
        if (changeBack) {
            arg = arg.replace("{", "<").replace("}", ">");
        }
        return arg;
    }

    private int[] locateTag(String arg) {
        Matcher tagMatcher = tagRegex.matcher(arg);
        if (tagMatcher.find()) {
            return new int[]{tagMatcher.start(), tagMatcher.end() - 1};
        }
        return null;
    }

    public List<String> fillArguments(List<String> args, ScriptEntry scriptEntry) {
        return this.fillArguments(args, scriptEntry, false);
    }

    public List<String> fillArguments(List<String> args, ScriptEntry scriptEntry, boolean instant) {
        ArrayList<String> filledArgs = new ArrayList<String>();
        if (args != null) {
            for (String argument : args) {
                if (scriptEntry.getPlayer() == null && scriptEntry.getOfflinePlayer() != null) {
                    filledArgs.add(this.tag(scriptEntry.getOfflinePlayer(), scriptEntry.getNPC(), argument, instant, scriptEntry));
                    continue;
                }
                filledArgs.add(this.tag((OfflinePlayer)scriptEntry.getPlayer(), scriptEntry.getNPC(), argument, instant, scriptEntry));
            }
        }
        return filledArgs;
    }

    public List<String> fillArguments(String[] args, Player player, dNPC npc) {
        ArrayList<String> filledArgs = new ArrayList<String>();
        if (args != null) {
            for (String argument : args) {
                filledArgs.add(this.tag((OfflinePlayer)player, npc, argument, false));
            }
        }
        return filledArgs;
    }
}

