/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.AssignmentScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractScriptHelper {
    /*
     * WARNING - void declaration
     */
    public static InteractScriptContainer getInteractScript(dNPC npc, Player player, Class<? extends AbstractTrigger> trigger) {
        if (npc == null || player == null || trigger == null) {
            return null;
        }
        AssignmentScriptContainer assignmentScript = npc.getAssignmentTrait().getAssignment();
        if (assignmentScript == null) {
            return null;
        }
        List<Object> assignedScripts = new ArrayList();
        if (assignmentScript.contains("INTERACT SCRIPTS")) {
            assignedScripts = assignmentScript.getStringList("INTERACT SCRIPTS");
        }
        if (assignedScripts.isEmpty()) {
            return null;
        }
        dB.echoDebug(dB.DebugElement.Header, "Getting interact script: " + npc.getName() + "/" + player.getName());
        ArrayList<PriorityPair> interactableScripts = new ArrayList<PriorityPair>();
        for (String string : assignedScripts) {
            void var7_8;
            Integer priority;
            String name;
            block21: {
                String string2 = string.toUpperCase();
                name = null;
                if (Character.isDigit(string2.charAt(0))) {
                    try {
                        priority = Integer.valueOf(string2.split(" ", 2)[0]);
                        name = string2.split(" ", 2)[1].replace("^", "");
                        break block21;
                    }
                    catch (Exception e) {
                        dB.echoError("Invalid Interact assignment for '" + string2 + "'. Is the script name missing?");
                        continue;
                    }
                }
                dB.echoError("Script '" + name + "' has an invalid priority! Assuming '0'.");
                name = string2;
                String string3 = "0 " + string2;
                priority = 0;
            }
            try {
                InteractScriptContainer interactScript = ScriptRegistry.getScriptContainerAs(name, InteractScriptContainer.class);
                if (interactScript.checkBaseRequirements(player, npc)) {
                    dB.echoApproval("'" + (String)var7_8 + "' meets requirements.");
                    if (interactScript.checkCooldown(player)) {
                        interactableScripts.add(new PriorityPair(priority, var7_8.split(" ", 2)[1]));
                    } else {
                        dB.echoDebug(ChatColor.GOLD + " ...but, isn't cooled down, yet! Skipping.");
                    }
                } else {
                    dB.echoDebug("'" + (String)var7_8 + "' does not meet requirements.");
                }
            }
            catch (Exception e) {
                dB.echoError(ChatColor.RED + "'" + (String)var7_8 + "' has a bad requirement, skipping.");
                if (!dB.showStackTraces) {
                    dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                }
                e.printStackTrace();
            }
            dB.echoDebug(dB.DebugElement.Spacer);
        }
        if (interactableScripts.size() == 1) {
            String script = ((PriorityPair)interactableScripts.get(0)).getName();
            dB.echoApproval("Highest scoring script is " + script + ".");
            dB.echoDebug(dB.DebugElement.Footer);
            return ScriptRegistry.getScriptContainerAs(script.replace("^", ""), InteractScriptContainer.class);
        }
        if (interactableScripts.isEmpty()) {
            dB.echoDebug(ChatColor.YELLOW + "+> " + ChatColor.WHITE + "No scripts meet requirements!");
            dB.echoDebug(dB.DebugElement.Footer);
            return null;
        }
        Collections.sort(interactableScripts);
        for (int a = interactableScripts.size() - 1; a >= 0; --a) {
            InteractScriptContainer interactScriptContainer = ScriptRegistry.getScriptContainerAs(((PriorityPair)interactableScripts.get(a)).name.replace("^", ""), InteractScriptContainer.class);
            dB.echoDebug("Checking script '" + ((PriorityPair)interactableScripts.get(a)).getName() + "'.");
            if (((PriorityPair)interactableScripts.get(a)).getName().startsWith("^")) {
                if (interactScriptContainer.containsTriggerInStep(InteractScriptHelper.getCurrentStep(player, interactScriptContainer.getName()), trigger)) {
                    dB.echoDebug("...found trigger!");
                    dB.echoApproval("Highest scoring script is " + interactScriptContainer.getName() + ".");
                    dB.echoDebug(dB.DebugElement.Footer);
                    return interactScriptContainer;
                }
            } else {
                dB.echoDebug("...script is good!");
                dB.echoApproval("Highest scoring script is " + interactScriptContainer.getName() + ".");
                dB.echoDebug(dB.DebugElement.Footer);
                return interactScriptContainer;
            }
            dB.echoDebug("...no trigger on this overlay assignment. Skipping.");
        }
        return null;
    }

    public static String getCurrentStep(Player player, String scriptName) {
        if (scriptName == null) {
            return null;
        }
        if (DenizenAPI._saves().contains("Players." + player.getName() + "." + "Scripts." + scriptName.toUpperCase() + "." + "Current Step")) {
            return DenizenAPI._saves().getString("Players." + player.getName() + "." + "Scripts." + scriptName.toUpperCase() + "." + "Current Step").toUpperCase();
        }
        return ScriptRegistry.getScriptContainerAs(scriptName, InteractScriptContainer.class).getDefaultStepName().toUpperCase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PriorityPair
    implements Comparable<PriorityPair> {
        int priority;
        private String name;

        public PriorityPair(int priority, String scriptName) {
            this.priority = priority;
            this.name = scriptName.toUpperCase();
        }

        @Override
        public int compareTo(PriorityPair pair) {
            return this.priority < pair.priority ? -1 : (this.priority > pair.priority ? 1 : 0);
        }

        public String getName() {
            return this.name;
        }
    }
}

