/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.events.dScriptReloadEvent;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class ProximityTrigger
extends AbstractTrigger
implements Listener {
    private static int maxProximityDistance = 25;
    private static Map<Player, Set<Integer>> proximityTracker = new ConcurrentHashMap<Player, Set<Integer>>();

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @EventHandler
    public void proximityTrigger(PlayerMoveEvent event) {
        if (!event.getTo().getBlock().equals(event.getFrom().getBlock())) {
            org.bukkit.Location toBlockLocation = event.getTo().getBlock().getLocation();
            for (dNPC npc : DenizenAPI.getCurrentInstance().getNPCRegistry().getSpawnedNPCs()) {
                if (!npc.getCitizen().hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getCitizen().getTrait(TriggerTrait.class)).isEnabled(this.name) || !npc.isSpawned() || !npc.getLocation().getWorld().equals(event.getPlayer().getWorld()) && this.hasExitedProximityOf(event.getPlayer(), npc) || !this.isCloseEnough(event.getPlayer(), npc) && this.hasExitedProximityOf(event.getPlayer(), npc)) continue;
                Player player = event.getPlayer();
                InteractScriptContainer script = npc.getInteractScriptQuietly(event.getPlayer(), this.getClass());
                int entryRadius = npc.getTriggerTrait().getRadius(this.name);
                int exitRadius = npc.getTriggerTrait().getRadius(this.name);
                if (script != null) {
                    try {
                        if (script.hasTriggerOptionFor(this.getClass(), player, null, "ENTRY RADIUS")) {
                            entryRadius = Integer.valueOf(script.getTriggerOptionFor(this.getClass(), player, null, "ENTRY RADIUS"));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        dB.echoDebug("Entry Radius was not an integer.  Assuming " + entryRadius + " as the radius.");
                    }
                    try {
                        if (script.hasTriggerOptionFor(this.getClass(), player, null, "EXIT RADIUS")) {
                            entryRadius = Integer.valueOf(script.getTriggerOptionFor(this.getClass(), player, null, "EXIT RADIUS"));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        dB.echoDebug("Exit Radius was not an integer.  Assuming " + exitRadius + " as the radius.");
                    }
                }
                Location npcLocation = npc.getLocation();
                boolean playerChangedWorlds = false;
                if (npcLocation.getWorld() != event.getPlayer().getWorld()) {
                    playerChangedWorlds = true;
                }
                if (!this.hasExitedProximityOf(event.getPlayer(), npc) && (playerChangedWorlds || npc.getLocation().distance(toBlockLocation) >= (double)exitRadius)) {
                    if (!npc.getTriggerTrait().triggerCooldownOnly(this, event.getPlayer())) continue;
                    this.exitProximityOf(event.getPlayer(), npc);
                    dB.echoDebug(ChatColor.YELLOW + "FOUND! NPC is in EXITING range: '" + npc.getName() + "'");
                    npc.action("exit proximity", event.getPlayer());
                    this.parse(npc, player, script, "EXIT");
                    continue;
                }
                if (!this.hasExitedProximityOf(event.getPlayer(), npc) || !(npc.getLocation().distance(toBlockLocation) <= (double)entryRadius) || !npc.getTriggerTrait().triggerCooldownOnly(this, event.getPlayer())) continue;
                this.enterProximityOf(event.getPlayer(), npc);
                npc.action("enter proximity", event.getPlayer());
                this.parse(npc, player, script, "ENTRY");
            }
        }
    }

    private boolean isCloseEnough(Player player, dNPC npc) {
        org.bukkit.Location pLoc = player.getLocation();
        Location nLoc = npc.getLocation();
        if (Math.abs(pLoc.getBlockX() - nLoc.getBlockX()) > maxProximityDistance) {
            return false;
        }
        if (Math.abs(pLoc.getBlockY() - nLoc.getBlockY()) > maxProximityDistance) {
            return false;
        }
        return Math.abs(pLoc.getBlockZ() - nLoc.getBlockZ()) <= maxProximityDistance;
    }

    @EventHandler
    public void checkMaxProximities(dScriptReloadEvent event) {
        for (String string : ScriptRegistry._getScriptNames()) {
        }
    }

    private boolean hasExitedProximityOf(Player player, dNPC npc) {
        if (!proximityTracker.containsKey(player)) {
            return true;
        }
        return !proximityTracker.get(player).contains(npc.getId());
    }

    private void enterProximityOf(Player player, dNPC npc) {
        Set<Integer> npcs = new HashSet<Integer>();
        if (proximityTracker.containsKey(player)) {
            npcs = proximityTracker.get(player);
        }
        npcs.add(npc.getId());
        proximityTracker.put(player, npcs);
    }

    private void exitProximityOf(Player player, dNPC npc) {
        Set<Object> npcs = new HashSet();
        if (proximityTracker.containsKey(player)) {
            npcs = proximityTracker.get(player);
        }
        if (npcs.contains(npc.getId())) {
            npcs.remove(npc.getId());
        }
        proximityTracker.put(player, npcs);
    }
}

