/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.events.ScriptFailEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Script;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class FailCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String player = null;
        Script script = scriptEntry.getScript();
        if (scriptEntry.getPlayer() != null) {
            player = scriptEntry.getPlayer().getName();
        }
        if (player == null && scriptEntry.getOfflinePlayer() != null) {
            player = scriptEntry.getOfflinePlayer().getName();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesScript(arg)) {
                script = aH.getScriptFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (player == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (script == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_SCRIPT);
        }
        scriptEntry.addObject("script", script);
        scriptEntry.addObject("player", player);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String player = (String)scriptEntry.getObject("player");
        Script script = (Script)scriptEntry.getObject("script");
        dB.report(this.getName(), aH.debugObj("Player", player) + script.debug());
        this.failScript(player, script.getName());
    }

    public void failScript(String playerName, String scriptName) {
        scriptName = scriptName.toUpperCase();
        int fails = this.denizen.getSaves().getInt("Players." + playerName + "." + scriptName + "." + "Failed", 0);
        this.denizen.getSaves().set("Players." + playerName + "." + scriptName + "." + "Failed", (Object)(++fails));
        this.denizen.saveSaves();
        ScriptFailEvent event = new ScriptFailEvent(playerName, scriptName, fails);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    public static int getScriptFails(String playerName, String scriptName) {
        return DenizenAPI.getCurrentInstance().getSaves().getInt("Players." + playerName + "." + scriptName.toUpperCase() + "." + "Failed", 0);
    }
}

