/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class WalkToCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Location location = null;
        float speed = -1.0f;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("SPEED", arg, aH.ArgumentType.Double)) {
                speed = (float)aH.getDoubleFrom(arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("location", location).addObject("speed", Float.valueOf(speed));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location location = (Location)scriptEntry.getObject("location");
        Float speed = (Float)scriptEntry.getObject("speed");
        scriptEntry.getNPC().getNavigator().setTarget((org.bukkit.Location)location);
        if (speed.floatValue() > 0.0f) {
            scriptEntry.getNPC().getNavigator().getLocalParameters().speedModifier(speed.floatValue());
        }
    }
}

