/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.utilities.Depends;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.NBTItem;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerTags
implements Listener {
    public static Map<String, List<String>> playerChatHistory = new ConcurrentHashMap<String, List<String>>();

    public PlayerTags(Denizen denizen) {
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void addMessage(AsyncPlayerChatEvent event) {
        List<String> history = new ArrayList<String>();
        if (playerChatHistory.containsKey(event.getPlayer().getName())) {
            history = playerChatHistory.get(event.getPlayer().getName());
        }
        if (history.size() > 10) {
            history.remove(9);
        }
        history.add(0, event.getMessage());
        playerChatHistory.put(event.getPlayer().getName(), history);
    }

    @EventHandler
    public void playerTags(ReplaceableTagEvent event) {
        String specifierContext;
        if (!event.matches("PLAYER")) {
            return;
        }
        Player p = event.getPlayer();
        String type = event.getType() != null ? event.getType().toUpperCase() : "";
        String subType = event.getSubType() != null ? event.getSubType().toUpperCase() : "";
        String subTypeContext = event.getSubTypeContext() != null ? event.getSubTypeContext().toUpperCase() : "";
        String specifier = event.getSpecifier() != null ? event.getSpecifier().toUpperCase() : "";
        String string = specifierContext = event.getSpecifierContext() != null ? event.getSpecifierContext().toUpperCase() : "";
        if (type.equals("ONLINE_PLAYERS")) {
            StringBuilder players = new StringBuilder();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.append(player.getName());
                players.append("|");
            }
            event.setReplaced(players.toString().substring(0, players.length() - 1));
            return;
        }
        if (type.equals("OFFLINE_PLAYERS")) {
            StringBuilder players = new StringBuilder();
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                players.append(player.getName());
                players.append("|");
            }
            event.setReplaced(players.toString().substring(0, players.length() - 1));
            return;
        }
        if (type.equals("ONLINE_OPS")) {
            StringBuilder players = new StringBuilder();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOp()) continue;
                players.append(player.getName());
                players.append("|");
            }
            event.setReplaced(players.toString().substring(0, players.length() - 1));
            return;
        }
        if (type.equals("OFFLINE_OPS")) {
            StringBuilder players = new StringBuilder();
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                if (!player.isOp()) continue;
                players.append(player.getName());
                players.append("|");
            }
            event.setReplaced(players.toString().substring(0, players.length() - 1));
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        if (type.equals("CHAT_HISTORY")) {
            if (event.hasTypeContext()) {
                if (aH.matchesInteger(event.getTypeContext()) && playerChatHistory.containsKey(event.getPlayer().getName())) {
                    List<String> history = playerChatHistory.get(event.getPlayer().getName());
                    if (history.size() < aH.getIntegerFrom(event.getTypeContext())) {
                        event.setReplaced(history.get(history.size() - 1));
                    } else {
                        event.setReplaced(history.get(aH.getIntegerFrom(event.getTypeContext()) - 1));
                    }
                }
            } else if (playerChatHistory.containsKey(event.getPlayer().getName())) {
                event.setReplaced(playerChatHistory.get(event.getPlayer().getName()).get(0));
            }
        } else if (type.equals("ITEM_IN_HAND")) {
            if (subType.equals("QTY")) {
                event.setReplaced(String.valueOf(p.getItemInHand().getAmount()));
            } else if (subType.equals("ID")) {
                event.setReplaced(String.valueOf(p.getItemInHand().getTypeId()));
            } else if (subType.equals("DURABILITY")) {
                event.setReplaced(String.valueOf(p.getItemInHand().getDurability()));
            } else if (subType.equals("DATA")) {
                event.setReplaced(String.valueOf(p.getItemInHand().getData()));
            } else if (subType.equals("MAX_STACK")) {
                event.setReplaced(String.valueOf(p.getItemInHand().getMaxStackSize()));
            } else if (subType.equals("ENCHANTMENTS")) {
                event.setReplaced(NBTItem.getEnchantments(p.getItemInHand()).asDScriptList());
            } else if (subType.equals("ENCHANTMENTS_WITH_LEVEL")) {
                event.setReplaced(NBTItem.getEnchantments(p.getItemInHand()).asDScriptListWithLevels());
            } else if (subType.equals("ENCHANTMENTS_WITH_LEVEL_ONLY")) {
                event.setReplaced(NBTItem.getEnchantments(p.getItemInHand()).asDScriptListLevelsOnly());
            } else if (subType.equals("LORE")) {
                event.setReplaced(NBTItem.getLore(p.getItemInHand()).asDScriptList());
            } else if (subType.equals("DISPLAY")) {
                event.setReplaced(p.getItemInHand().getItemMeta().getDisplayName());
            } else if (subType.equals("MATERIAL")) {
                if (specifier.equals("FORMATTED")) {
                    String itemName = p.getItemInHand().getType().name().toLowerCase().replace('_', ' ');
                    int itemQty = p.getItemInHand().getAmount();
                    if (itemName.equals("air")) {
                        event.setReplaced("nothing");
                    } else if (itemName.equals("ice") || itemName.equals("dirt")) {
                        event.setReplaced(itemName);
                    } else if (itemQty > 1) {
                        if (itemName.equals("cactus")) {
                            event.setReplaced("cactuses");
                        } else if (itemName.endsWith("y")) {
                            event.setReplaced(itemName.substring(0, itemName.length() - 1) + "ies");
                        } else if (itemName.endsWith("s")) {
                            event.setReplaced(itemName);
                        } else {
                            event.setReplaced(itemName + "s");
                        }
                    } else if (itemName.equals("cactus")) {
                        event.setReplaced("a cactus");
                    } else if (itemName.endsWith("s")) {
                        event.setReplaced(itemName);
                    } else if (itemName.startsWith("a") || itemName.startsWith("e") || itemName.startsWith("i") || itemName.startsWith("o") || itemName.startsWith("u")) {
                        event.setReplaced("an " + itemName);
                    } else {
                        event.setReplaced("a " + itemName);
                    }
                } else {
                    event.setReplaced(p.getItemInHand().getType().name());
                }
            }
        } else if (type.equals("NAME")) {
            event.setReplaced(p.getName());
            if (subType.equals("DISPLAY")) {
                event.setReplaced(p.getDisplayName());
            } else if (subType.equals("LIST")) {
                event.setReplaced(p.getPlayerListName());
            }
        } else if (type.equals("LOCATION")) {
            event.setReplaced(p.getLocation().getBlockX() + "," + p.getLocation().getBlockY() + "," + p.getLocation().getBlockZ() + "," + p.getWorld().getName());
            if (subType.equals("FORMATTED")) {
                event.setReplaced("X '" + p.getLocation().getBlockX() + "', Y '" + p.getLocation().getBlockY() + "', Z '" + p.getLocation().getBlockZ() + "', in world '" + p.getWorld().getName() + "'");
            } else if (subType.equals("X")) {
                event.setReplaced(String.valueOf(p.getLocation().getBlockX()));
            } else if (subType.equals("Y")) {
                event.setReplaced(String.valueOf(p.getLocation().getBlockY()));
            } else if (subType.equals("Z")) {
                event.setReplaced(String.valueOf(p.getLocation().getBlockZ()));
            } else if (subType.equals("WORLD")) {
                event.setReplaced(p.getWorld().getName());
            } else if (subType.equals("STANDING_ON")) {
                if (specifier.equals("FORMATTED")) {
                    event.setReplaced(p.getLocation().add(0.0, -1.0, 0.0).getBlock().getType().name().toLowerCase().replace('_', ' '));
                } else {
                    event.setReplaced(p.getLocation().add(0.0, -1.0, 0.0).getBlock().getType().name());
                }
            } else if (subType.equals("WORLD_SPAWN")) {
                event.setReplaced(p.getWorld().getSpawnLocation().getBlockX() + "," + p.getWorld().getSpawnLocation().getBlockY() + "," + p.getWorld().getSpawnLocation().getBlockZ() + "," + p.getWorld().getName());
            } else if (subType.equals("BED_SPAWN")) {
                event.setReplaced(p.getBedSpawnLocation().getBlockX() + "," + p.getBedSpawnLocation().getBlockY() + "," + p.getBedSpawnLocation().getBlockZ() + "," + p.getWorld().getName());
            }
        } else if (type.equals("HEALTH")) {
            event.setReplaced(String.valueOf(p.getHealth()));
            if (subType.equals("FORMATTED")) {
                int maxHealth = p.getMaxHealth();
                if (event.getType().split("\\.").length > 2) {
                    maxHealth = Integer.valueOf(event.getType().split(".")[2]);
                }
                if ((double)((float)p.getHealth() / (float)maxHealth) < 0.1) {
                    event.setReplaced("dying");
                } else if ((double)((float)p.getHealth() / (float)maxHealth) < 0.4) {
                    event.setReplaced("seriously wounded");
                } else if ((double)((float)p.getHealth() / (float)maxHealth) < 0.75) {
                    event.setReplaced("injured");
                } else if ((float)p.getHealth() / (float)maxHealth < 1.0f) {
                    event.setReplaced("scraped");
                } else {
                    event.setReplaced("healthy");
                }
            } else if (subType.equals("PERCENTAGE")) {
                int maxHealth = p.getMaxHealth();
                if (event.getType().split("\\.").length > 2) {
                    maxHealth = Integer.valueOf(event.getType().split(".")[2]);
                }
                event.setReplaced(String.valueOf((float)p.getHealth() / (float)maxHealth * 100.0f));
            }
        } else if (type.equals("FOOD_LEVEL")) {
            event.setReplaced(String.valueOf(p.getFoodLevel()));
            if (subType.equals("FORMATTED")) {
                int maxFood = 20;
                if (event.getType().split("\\.").length > 2) {
                    maxFood = Integer.valueOf(event.getType().split(".")[2]);
                }
                if ((double)((float)p.getHealth() / (float)maxFood) < 0.1) {
                    event.setReplaced("starving");
                } else if ((double)((float)p.getFoodLevel() / (float)maxFood) < 0.4) {
                    event.setReplaced("famished");
                } else if ((double)((float)p.getFoodLevel() / (float)maxFood) < 0.75) {
                    event.setReplaced("hungry");
                } else if ((float)p.getFoodLevel() / (float)maxFood < 1.0f) {
                    event.setReplaced("parched");
                } else {
                    event.setReplaced("healthy");
                }
            } else if (subType.equals("PERCENTAGE")) {
                int maxFood = 20;
                if (event.getType().split("\\.").length > 2) {
                    maxFood = Integer.valueOf(event.getType().split(".")[2]);
                }
                event.setReplaced(String.valueOf((float)p.getFoodLevel() / (float)maxFood * 100.0f));
            }
        } else if (type.equals("MONEY")) {
            if (Depends.economy != null) {
                event.setReplaced(String.valueOf(Depends.economy.getBalance(p.getName())));
                if (subType.equals("ASINT")) {
                    event.setReplaced(String.valueOf((int)Depends.economy.getBalance(p.getName())));
                } else if (subType.equals("CURRENCY")) {
                    if (specifier.equals("SINGULAR")) {
                        event.setReplaced(Depends.economy.currencyNameSingular());
                    } else if (specifier.equals("PLURAL")) {
                        event.setReplaced(Depends.economy.currencyNamePlural());
                    }
                }
            } else {
                dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
            }
        } else if (type.equals("IS_OP")) {
            event.setReplaced(String.valueOf(p.isOp()));
        } else if (type.equals("IS_BANNED")) {
            event.setReplaced(String.valueOf(p.isBanned()));
        } else if (type.equals("IS_ONLINE")) {
            event.setReplaced(String.valueOf(p.isOnline()));
        } else if (type.equals("TIME")) {
            event.setReplaced(String.valueOf(p.getPlayerTime()));
            if (subType.equals("PERIOD")) {
                if (p.getPlayerTime() < 13500L || p.getPlayerTime() > 23000L) {
                    event.setReplaced("day");
                } else if (p.getPlayerTime() > 13500L) {
                    event.setReplaced("night");
                }
            }
        } else if (type.equals("WEATHER")) {
            if (p.getWorld().hasStorm()) {
                event.setReplaced("storming");
            } else if (p.getPlayerTime() > 13500L) {
                event.setReplaced("clear");
            } else {
                event.setReplaced("sunny");
            }
        } else if (type.equals("EQUIPMENT")) {
            event.setReplaced(String.valueOf(event.getNPC().getEntity().getHealth()));
        } else if (type.equals("INVENTORY")) {
            if (subType.equals("CONTAINS") && aH.matchesItem("item:" + subTypeContext)) {
                Item item = aH.getItemFrom("item:" + subTypeContext);
                if (specifier.equals("QTY") && aH.matchesQuantity("qty:" + specifierContext)) {
                    int qty = aH.getIntegerFrom(specifierContext);
                    event.setReplaced(String.valueOf(event.getPlayer().getInventory().containsAtLeast((ItemStack)item, qty)));
                } else {
                    event.setReplaced(String.valueOf(event.getPlayer().getInventory().containsAtLeast((ItemStack)item, 1)));
                }
            }
        } else if (type.equals("XP")) {
            event.setReplaced(String.valueOf(event.getPlayer().getExp() * 100.0f));
            if (subType.equals("TO_NEXT_LEVEL")) {
                event.setReplaced(String.valueOf(p.getExpToLevel()));
            } else if (subType.equals("TOTAL")) {
                event.setReplaced(String.valueOf(p.getTotalExperience()));
            } else if (subType.equals("LEVEL")) {
                event.setReplaced(String.valueOf(p.getLevel()));
            }
        }
    }
}

