/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.ScriptQueue;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Script;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class RuntaskCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Map<String, String> context = null;
        Script script = null;
        Duration delay = null;
        Duration speed = null;
        ScriptQueue queue = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesScript(arg)) {
                script = aH.getScriptFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("DELAY", arg, aH.ArgumentType.Duration)) {
                delay = aH.getDurationFrom(arg);
                delay.setPrefix("Delay");
                continue;
            }
            if (aH.matchesQueue(arg)) {
                queue = aH.getQueueFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("SPEED", arg, aH.ArgumentType.Duration)) {
                speed = aH.getDurationFrom(arg);
                continue;
            }
            if (aH.matchesArg("QUEUE", arg)) continue;
            if (aH.matchesArg("INSTANT, INSTANTLY", arg)) {
                speed = new Duration(0);
                continue;
            }
            if (aH.matchesContext(arg)) {
                context = aH.getContextFrom(arg);
                continue;
            }
            if (ScriptRegistry.containsScript(aH.getStringFrom(arg))) {
                script = aH.getScriptFrom(arg);
                if (script.getType().equalsIgnoreCase("TASK")) continue;
                script = null;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (script == null) {
            throw new InvalidArgumentsException("Must define a script to be run!");
        }
        if (queue == null) {
            queue = ScriptQueue._getQueue(scriptEntry.getResidingQueue());
        }
        if (queue.getSpeed().getTicksAsInt() == 0 && ((TaskScriptContainer)script.getContainer()).getSpeed().getTicksAsInt() > 0) {
            queue = ScriptQueue._getQueue(ScriptQueue._getNextId());
        }
        if (queue.getSpeed().getTicksAsInt() > 0 && ((TaskScriptContainer)script.getContainer()).getSpeed().getTicksAsInt() == 0) {
            queue = ScriptQueue._getQueue(ScriptQueue._getNextId());
        }
        if (speed == null) {
            speed = ((TaskScriptContainer)script.getContainer()).getSpeed();
        }
        scriptEntry.addObject("speed", speed.setPrefix("Speed")).addObject("queue", queue).addObject("delay", delay != null ? delay.setPrefix("Delay") : null).addObject("script", script).addObject("context", context);
        dB.log(queue == null ? "yes" : "no");
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        HashMap context = (HashMap)scriptEntry.getObject("context");
        Script script = (Script)scriptEntry.getObject("script");
        ScriptQueue queue = (ScriptQueue)scriptEntry.getObject("queue");
        Duration speed = (Duration)scriptEntry.getObject("speed");
        Duration delay = (Duration)scriptEntry.getObject("delay");
        dB.report(this.getName(), script.debug() + (delay != null ? delay.debug() : "") + speed.debug() + aH.debugObj("Queue", queue.id) + (context != null ? aH.debugObj("Context", ((Object)context).toString()) : ""));
        if (delay == null) {
            ((TaskScriptContainer)script.getContainer()).setSpeed(speed).runTaskScript(queue.id, scriptEntry.getPlayer(), scriptEntry.getNPC(), context);
        } else {
            ((TaskScriptContainer)script.getContainer()).setSpeed(speed).runTaskScriptWithDelay(queue.id, scriptEntry.getPlayer(), scriptEntry.getNPC(), context, delay);
        }
    }
}

