/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ChairCommand
extends AbstractCommand
implements Listener {
    public static ConcurrentHashMap<Integer, Block> chairRegistry = new ConcurrentHashMap();

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
        if (DenizenAPI.getCurrentInstance().getSaves().getConfigurationSection("dScript.Chair Registry") != null) {
            dB.log("...loading ChairRegistry");
            for (String id : DenizenAPI.getCurrentInstance().getSaves().getConfigurationSection("dScript.Chair Registry").getKeys(false)) {
                try {
                    chairRegistry.put(Integer.valueOf(id), Location.valueOf(DenizenAPI.getCurrentInstance().getSaves().getString("dScript.Chair Registry." + id)).getBlock());
                }
                catch (Exception e) {
                    dB.log("Encountered an invalid entry in the Chair Registry.. skipping.");
                }
            }
        } else {
            dB.log("skipped loading ChairRegistry");
        }
        this.denizen.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.denizen, new Runnable(){

            public void run() {
                for (Map.Entry<Integer, Block> entry : chairRegistry.entrySet()) {
                    NPC npc = CitizensAPI.getNPCRegistry().getById(entry.getKey().intValue());
                    if (npc == null) {
                        chairRegistry.remove(entry.getKey());
                    }
                    if (!Utilities.checkLocation(npc.getBukkitEntity(), entry.getValue().getLocation(), 1)) {
                        ChairCommand.this.makeStand(DenizenAPI.getDenizenNPC(npc));
                        continue;
                    }
                    ChairCommand.this.makeSitAllPlayers(DenizenAPI.getDenizenNPC(npc));
                }
            }
        }, 40L, 40L);
    }

    public void onDisable() {
        dB.log("clearing old registry");
        DenizenAPI.getCurrentInstance().getSaves().set("dScript.Chair Registry", null);
        dB.log("saving chairregistry");
        for (Map.Entry<Integer, Block> entry : chairRegistry.entrySet()) {
            DenizenAPI.getCurrentInstance().getSaves().set("dScript.Chair Registry." + entry.getKey(), (Object)new Location(entry.getValue().getLocation()).dScriptArgValue());
        }
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Block chairBlock = null;
        ChairAction chairAction = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesLocation(arg)) {
                chairBlock = aH.getLocationFrom(arg).getBlock();
                continue;
            }
            if (aH.matchesArg("SIT, STAND", arg)) {
                chairAction = ChairAction.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (chairBlock == null && chairAction != ChairAction.STAND) {
            throw new InvalidArgumentsException("Must specify a location to sit!");
        }
        scriptEntry.addObject("chairBlock", chairBlock).addObject("chairAction", (Object)chairAction);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Block chairBlock = (Block)scriptEntry.getObject("chairBlock");
        ChairAction chairAction = (ChairAction)((Object)scriptEntry.getObject("chairAction"));
        dNPC npc = scriptEntry.getNPC();
        switch (chairAction) {
            case SIT: {
                if (this.isSitting(npc).booleanValue()) {
                    dB.echoError("...NPC is already sitting!");
                    return;
                }
                if (this.isChair(chairBlock).booleanValue()) {
                    dB.echoError("...location is already being sat on!");
                    return;
                }
                npc.getEntity().teleport(chairBlock.getLocation().add(0.5, 0.0, 0.5), PlayerTeleportEvent.TeleportCause.PLUGIN);
                chairBlock.getLocation().setYaw(this.yawSet(chairBlock));
                this.makeSitAllPlayers(npc);
                npc.action("sit", scriptEntry.getPlayer());
                chairRegistry.put(npc.getId(), chairBlock);
                break;
            }
            case STAND: {
                if (!this.isSitting(npc).booleanValue()) {
                    dB.echoError("...NPC is already standing!");
                    return;
                }
                this.makeStand(npc);
                npc.action("stand", scriptEntry.getPlayer());
                break;
            }
            case TOGGLE: {
                if (chairBlock == null) {
                    this.makeStand(npc);
                    npc.action("stand", scriptEntry.getPlayer());
                    dB.echoDebug("...no chair specified, making NPC stand.");
                    break;
                }
                dB.echoDebug("...having NPC sit at specified chair");
                npc.getEntity().teleport(chairBlock.getLocation().add(0.5, 0.0, 0.5), PlayerTeleportEvent.TeleportCause.PLUGIN);
                chairBlock.getLocation().setYaw(this.yawSet(chairBlock));
                this.makeSitAllPlayers(npc);
                npc.action("sit", scriptEntry.getPlayer());
                break;
            }
        }
    }

    public void makeSitAllPlayers(dNPC npc) {
        try {
            PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(40);
            packet.getSpecificModifier(Integer.TYPE).write(0, (Object)npc.getEntity().getEntityId());
            WrappedDataWatcher watcher = new WrappedDataWatcher();
            watcher.setObject(0, (Object)4);
            packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
            for (Player player : this.denizen.getServer().getOnlinePlayers()) {
                if (!npc.getEntity().getWorld().equals(player.getWorld())) continue;
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
                catch (InvocationTargetException e) {
                    dB.echoError("...error sending packet to player: " + player.getName());
                }
            }
        }
        catch (Error e) {
            dB.echoError("ProtocolLib required for SIT command!!");
        }
    }

    public void makeSitSpecificPlayer(dNPC npc, Player player) {
        try {
            PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(40);
            packet.getSpecificModifier(Integer.TYPE).write(0, (Object)npc.getEntity().getEntityId());
            WrappedDataWatcher watcher = new WrappedDataWatcher();
            watcher.setObject(0, (Object)4);
            packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
            if (npc.getEntity().getWorld().equals(player.getWorld())) {
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
                catch (Exception e) {
                    dB.echoError("...error sending packet to player: " + player.getName());
                }
            }
        }
        catch (Error e) {
            dB.echoError("ProtocolLib required for SIT command!!");
        }
    }

    public void makeStand(dNPC npc) {
        try {
            PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(40);
            packet.getSpecificModifier(Integer.TYPE).write(0, (Object)npc.getEntity().getEntityId());
            WrappedDataWatcher watcher = new WrappedDataWatcher();
            watcher.setObject(0, (Object)0);
            packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
            for (Player player : this.denizen.getServer().getOnlinePlayers()) {
                if (!npc.getEntity().getWorld().equals(player.getWorld())) continue;
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                }
                catch (InvocationTargetException e) {
                    dB.echoError("...error sending packet to player: " + player.getName());
                }
            }
        }
        catch (Error e) {
            dB.echoError("ProtocolLib required for SIT command!!");
        }
        chairRegistry.remove(npc.getCitizen().getId());
    }

    public Boolean isSitting(dNPC npc) {
        if (chairRegistry.containsKey(npc.getId())) {
            return true;
        }
        return false;
    }

    public Boolean isChair(Block block) {
        if (chairRegistry.containsValue(block)) {
            return true;
        }
        return false;
    }

    @EventHandler
    public void onNavigationBeginEvent(NavigationBeginEvent event) {
        dNPC npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (this.isSitting(npc).booleanValue()) {
            this.makeStand(npc);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.isChair(event.getBlock()).booleanValue()) {
            event.setCancelled(true);
            dB.echoDebug("..." + event.getPlayer().getName() + " tried to break an NPCs chair!");
        }
    }

    private float yawSet(Block chair) {
        if (chair.getData() == 0) {
            return 90.0f;
        }
        if (chair.getData() == 1) {
            return -90.0f;
        }
        if (chair.getData() == 2) {
            return 180.0f;
        }
        if (chair.getData() == 3) {
            return 0.0f;
        }
        return 0.0f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChairAction {
        SIT,
        STAND,
        TOGGLE;

    }
}

