/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class ListenCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String id = null;
        ListenAction listenAction = ListenAction.NEW;
        String listenerType = null;
        ArrayList<String> listenerArguments = new ArrayList<String>();
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("CANCEL", arg)) {
                listenAction = ListenAction.CANCEL;
                dB.echoDebug("...marked to CANCEL.");
                continue;
            }
            if (aH.matchesScript(arg)) {
                scriptEntry.setScript(aH.getStringFrom(arg));
                dB.echoDebug(dB.Messages.DEBUG_SET_SCRIPT, arg);
                continue;
            }
            if (aH.matchesArg("FINISH", arg)) {
                listenAction = ListenAction.FINISH;
                dB.echoDebug("...marked to FINISH.");
                continue;
            }
            if (aH.matchesValueArg("ID", arg, aH.ArgumentType.String)) {
                id = aH.getStringFrom(arg);
                dB.echoDebug("...ID set: '%s'", id);
                continue;
            }
            if (this.denizen.getListenerRegistry().get(arg) != null) {
                listenerType = arg;
                dB.echoDebug("...TYPE set: '%s'", listenerType);
                continue;
            }
            listenerArguments.add(arg);
        }
        if (id == null) {
            id = scriptEntry.getScript().getName();
        }
        if (scriptEntry.getPlayer() == null && (listenAction != ListenAction.CANCEL || scriptEntry.getOfflinePlayer() == null)) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        scriptEntry.addObject("action", (Object)listenAction);
        scriptEntry.addObject("type", listenerType);
        scriptEntry.addObject("args", listenerArguments);
        scriptEntry.addObject("id", id);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        ListenAction listenAction = (ListenAction)((Object)scriptEntry.getObject("action"));
        String listenerType = (String)scriptEntry.getObject("type");
        List listenerArguments = (List)scriptEntry.getObject("args");
        String id = (String)scriptEntry.getObject("id");
        switch (listenAction) {
            case NEW: {
                try {
                    this.denizen.getListenerRegistry().get(listenerType).createInstance(scriptEntry.getPlayer(), id).build(scriptEntry.getPlayer(), id, listenerType, listenerArguments, scriptEntry.getScript().getName());
                }
                catch (Exception e) {
                    dB.echoDebug("Cancelled creation of NEW listener!");
                    try {
                        this.denizen.getListenerRegistry().getListenerFor(scriptEntry.getPlayer(), id).cancel();
                    }
                    catch (Exception ex) {}
                }
                break;
            }
            case FINISH: {
                if (this.denizen.getListenerRegistry().getListenerFor(scriptEntry.getPlayer(), id) == null) break;
                this.denizen.getListenerRegistry().getListenerFor(scriptEntry.getPlayer(), id).finish();
                break;
            }
            case CANCEL: {
                if (scriptEntry.getPlayer() != null) {
                    if (this.denizen.getListenerRegistry().getListenerFor(scriptEntry.getPlayer(), id) == null) break;
                    this.denizen.getListenerRegistry().getListenerFor(scriptEntry.getPlayer(), id).cancel();
                    break;
                }
                this.denizen.getSaves().set("Listeners." + scriptEntry.getOfflinePlayer().getName() + "." + id, null);
            }
        }
    }

    public void onEnable() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListenAction {
        NEW,
        CANCEL,
        FINISH;

    }
}

