/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportCommand
extends AbstractCommand {
    public static final String NPC_ARG = "NPC";

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<Player> teleportEntities = new ArrayList<Player>();
        ArrayList<NPC> teleportNPCs = new ArrayList<NPC>();
        Location teleportLocation = null;
        Boolean teleportPlayer = true;
        for (String arg : scriptEntry.getArguments()) {
            if (arg.equalsIgnoreCase(NPC_ARG)) {
                teleportNPCs.add(scriptEntry.getNPC().getCitizen());
                teleportPlayer = false;
                continue;
            }
            if (aH.matchesLocation(arg)) {
                teleportLocation = aH.getLocationFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("TARGETS", arg, aH.ArgumentType.Custom)) {
                teleportPlayer = false;
                for (String target : aH.getListFrom(arg)) {
                    if (CitizensAPI.getNPCRegistry().getNPC((Entity)aH.getLivingEntityFrom(target)) != null) {
                        teleportNPCs.add(CitizensAPI.getNPCRegistry().getNPC((Entity)aH.getLivingEntityFrom(target)));
                        continue;
                    }
                    if (aH.getLivingEntityFrom(target) != null && aH.getLivingEntityFrom(target) instanceof Player) {
                        teleportEntities.add(aH.getPlayerFrom(target));
                        continue;
                    }
                    dB.echoError("Invalid TARGET '%s'!", target);
                }
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (teleportPlayer.booleanValue()) {
            teleportEntities.add(scriptEntry.getPlayer());
        }
        if (teleportLocation == null) {
            throw new InvalidArgumentsException("Missing LOCATION argument. No teleport location.");
        }
        if (teleportEntities.isEmpty() && teleportNPCs.isEmpty()) {
            throw new InvalidArgumentsException("Missing TARGETS argument. Nothing to teleport.");
        }
        scriptEntry.addObject("location", teleportLocation).addObject("entities", teleportEntities).addObject("npcs", teleportNPCs);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location teleportLocation = (Location)scriptEntry.getObject("location");
        List teleportEntities = (List)scriptEntry.getObject("entities");
        List teleportNPCs = (List)scriptEntry.getObject("npcs");
        dB.echoApproval("<G>Executing '<Y>" + this.getName() + "<G>': " + teleportLocation.debug() + ", " + "Targets=<Y>'" + teleportEntities.toString() + "/" + teleportNPCs.toString() + "<G>'");
        for (LivingEntity entity : teleportEntities) {
            entity.teleport((org.bukkit.Location)teleportLocation);
        }
        for (NPC npc : teleportNPCs) {
            npc.spawn((org.bukkit.Location)teleportLocation);
            npc.getBukkitEntity().teleport((org.bukkit.Location)teleportLocation, PlayerTeleportEvent.TeleportCause.COMMAND);
        }
    }
}

