/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatTrigger
extends AbstractTrigger
implements Listener {
    static final Pattern triggerPattern = Pattern.compile("\\/([^/]*)\\/");

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @EventHandler
    public void chatTrigger(AsyncPlayerChatEvent event) {
        InteractScriptContainer script;
        dNPC npc = Utilities.getClosestNPC(event.getPlayer().getLocation(), 25);
        if (npc == null) {
            return;
        }
        if (!npc.getCitizen().hasTrait(TriggerTrait.class)) {
            return;
        }
        if (!((TriggerTrait)npc.getCitizen().getTrait(TriggerTrait.class)).isEnabled(this.name)) {
            return;
        }
        if (npc.getTriggerTrait().getRadius(this.name) == -1) {
            npc.getTriggerTrait().setLocalRadius(this.name, Settings.TriggerDefaultRangeInBlocks(this.name));
        }
        if ((double)npc.getTriggerTrait().getRadius(this.name) < npc.getLocation().distance(event.getPlayer().getLocation())) {
            return;
        }
        if (Settings.ChatOnlyWhenHavingLineOfSightToNPC() && !npc.getEntity().hasLineOfSight((Entity)event.getPlayer())) {
            return;
        }
        if (Settings.ChatOnlyWhenLookingAtNPC() && !Utilities.isFacingEntity((Entity)event.getPlayer(), (Entity)npc.getEntity(), 45.0f)) {
            return;
        }
        if (!npc.getTriggerTrait().trigger(this, event.getPlayer())) {
            if (Settings.ChatGloballyIfNotInteractable()) {
                dB.echoDebug(ChatColor.YELLOW + "Resuming. " + ChatColor.WHITE + "The NPC is currently cooling down or engaged.");
                return;
            }
            event.setCancelled(true);
        }
        if (!(script = npc.getInteractScript(event.getPlayer(), this.getClass())).containsTriggerInStep(InteractScriptHelper.getCurrentStep(event.getPlayer(), script.getName()), this.getClass())) {
            if (!Settings.ChatGloballyIfNoChatTriggers()) {
                event.setCancelled(true);
                dB.echoDebug(event.getPlayer().getName() + " says to " + npc.getNicknameTrait().getNickname() + ", " + event.getMessage());
                return;
            }
            return;
        }
        String id = null;
        boolean matched = false;
        String replacementText = null;
        String regexId = null;
        String regexMessage = null;
        Map<Object, Object> idMap = new HashMap();
        if (script != null) {
            idMap = script.getIdMapFor(this.getClass(), event.getPlayer());
        }
        if (!idMap.isEmpty()) {
            for (Map.Entry entry : idMap.entrySet()) {
                Matcher matcher = triggerPattern.matcher((CharSequence)entry.getValue());
                while (matcher.find()) {
                    if (!script.checkSpecificTriggerScriptRequirementsFor(this.getClass(), event.getPlayer(), npc, (String)entry.getKey())) continue;
                    String keyword = matcher.group().replace("/", "");
                    if (this.isKeywordRegex(keyword).booleanValue()) {
                        Pattern pattern = Pattern.compile(keyword.substring(6));
                        Matcher m = pattern.matcher(event.getMessage());
                        if (!m.find()) continue;
                        regexId = (String)entry.getKey();
                        regexMessage = ((String)entry.getValue()).replace("/" + keyword + "/", m.group());
                        continue;
                    }
                    if (!event.getMessage().toUpperCase().contains(keyword.toUpperCase())) continue;
                    id = (String)entry.getKey();
                    replacementText = ((String)entry.getValue()).replace("/", "");
                    matched = true;
                }
                if (!matched) continue;
                break;
            }
        }
        if (!matched && regexId != null) {
            id = regexId;
            replacementText = regexMessage;
        }
        if (id != null) {
            event.setCancelled(true);
            Utilities.talkToNPC(replacementText, event.getPlayer(), npc, Settings.ChatToNpcBystandersRange());
            this.parse(npc, event.getPlayer(), script, id);
        } else if (!Settings.ChatGloballyIfFailedChatTriggers()) {
            event.setCancelled(true);
            dB.echoDebug(event.getPlayer().getName() + " says to " + npc.getNicknameTrait().getNickname() + ", " + replacementText);
            return;
        }
    }

    private Boolean isKeywordRegex(String keyWord) {
        return keyWord.toUpperCase().startsWith("REGEX:");
    }
}

