/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftLivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class HealthTrait
extends Trait
implements Listener {
    @Persist(value="max")
    private int maxhealth = 20;
    @Persist(value="current")
    private int currenthealth = 20;
    @Persist(value="animatedeath")
    private boolean animatedeath = true;
    @Persist(value="animatedeathdelayinseconds")
    private String animationDelay = "3s";
    @Persist(value="respawnondeath")
    private boolean respawn = true;
    @Persist(value="respawndelayinseconds")
    private String respawnDelay = "10s";
    @Persist(value="respawnlocation")
    private String respawnLocation = "<npc.location>";
    private boolean dying = false;
    private Location loc;

    public double getAnimationDelay() {
        return Duration.valueOf(this.animationDelay).getSeconds();
    }

    public double getRespawnDelay() {
        return Duration.valueOf(this.respawnDelay).getSeconds();
    }

    public void setRespawnLocation(String string) {
        if (aH.matchesLocation("location:" + string)) {
            this.respawnLocation = string;
        }
    }

    public void setRespawnDelay(int seconds) {
        this.respawnDelay = String.valueOf(seconds);
    }

    public void setRespawnDelay(String string) {
        if (aH.matchesDuration("duration:" + string)) {
            this.respawnDelay = string;
        }
    }

    public String getRespawnLocationAsString() {
        return this.respawnLocation;
    }

    public Location getRespawnLocation() {
        return aH.getLocationFrom(this.respawnLocation);
    }

    public void setDeathAnimationDelay(int seconds) {
        this.animationDelay = String.valueOf(seconds);
    }

    public void setDeathAnimationDelay(String string) {
        if (aH.matchesDuration("duration:" + string)) {
            this.animationDelay = string;
        }
    }

    public void setRespawnable(boolean respawnable) {
        this.respawn = respawnable;
    }

    public boolean isRespawnable() {
        return this.respawn;
    }

    public void animateOnDeath(boolean animate) {
        this.animatedeath = animate;
    }

    public boolean animatesOnDeath() {
        return this.animatedeath;
    }

    public void onSpawn() {
        this.dying = false;
        if (this.currenthealth > 0) {
            this.setHealth(this.currenthealth);
        } else {
            this.setHealth();
        }
    }

    public void onDespawn() {
        this.currenthealth = this.getHealth() > 0 ? this.getHealth() : -1;
    }

    public HealthTrait() {
        super("health");
    }

    public int getHealth() {
        if (!this.npc.isSpawned()) {
            return this.currenthealth;
        }
        return ((CraftLivingEntity)this.npc.getBukkitEntity()).getHandle().getHealth();
    }

    public void setMaxhealth(int newMax) {
        this.maxhealth = newMax;
    }

    public int getMaxhealth() {
        return this.maxhealth;
    }

    public void heal(int health) {
        this.setHealth(this.getHealth() + health);
    }

    public void setHealth() {
        this.setHealth(this.maxhealth);
    }

    public void setHealth(int health) {
        if (this.npc.getBukkitEntity() != null) {
            ((CraftLivingEntity)this.npc.getBukkitEntity()).getHandle().setHealth(health);
        }
        this.currenthealth = health;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeath(EntityDamageEvent event) {
        if (event.getEntity() != this.npc.getBukkitEntity() || this.dying) {
            return;
        }
        if (this.getHealth() - event.getDamage() > 0) {
            return;
        }
        this.dying = true;
        if (event instanceof EntityDamageByEntityEvent) {
            if (((EntityDamageByEntityEvent)event).getDamager() instanceof Player) {
                DenizenAPI.getDenizenNPC(this.npc).action("death", (Player)((EntityDamageByEntityEvent)event).getDamager());
                DenizenAPI.getDenizenNPC(this.npc).action("death by entity", (Player)((EntityDamageByEntityEvent)event).getDamager());
                DenizenAPI.getDenizenNPC(this.npc).action("death by player", (Player)((EntityDamageByEntityEvent)event).getDamager());
            } else {
                DenizenAPI.getDenizenNPC(this.npc).action("death", null);
                DenizenAPI.getDenizenNPC(this.npc).action("death by entity", null);
                DenizenAPI.getDenizenNPC(this.npc).action("death by monster", null);
                DenizenAPI.getDenizenNPC(this.npc).action("death by " + ((EntityDamageByEntityEvent)event).getDamager().getType().toString(), null);
            }
        } else if (event instanceof EntityDamageByBlockEvent) {
            DenizenAPI.getDenizenNPC(this.npc).action("death", null);
            DenizenAPI.getDenizenNPC(this.npc).action("death by block", null);
        }
        DenizenAPI.getCurrentInstance().tagManager();
        this.loc = aH.getLocationFrom(TagManager.tag(null, DenizenAPI.getDenizenNPC(this.npc), this.respawnLocation, false));
        if (this.loc == null) {
            this.loc = this.npc.getBukkitEntity().getLocation();
        }
        if (this.animatedeath) {
            this.setHealth();
            this.npc.getBukkitEntity().playEffect(EntityEffect.DEATH);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    HealthTrait.this.npc.despawn(DespawnReason.DEATH);
                    HealthTrait.this.setHealth();
                }
            }, (long)(Duration.valueOf(this.animationDelay).getSeconds() * 20.0));
        } else {
            this.npc.despawn(DespawnReason.DEATH);
            this.setHealth();
        }
        if (this.respawn) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    if (HealthTrait.this.npc.isSpawned()) {
                        return;
                    }
                    HealthTrait.this.npc.spawn(HealthTrait.this.loc);
                }
            }, (long)(Duration.valueOf(this.respawnDelay).getSeconds() * 20.0));
        }
    }
}

