/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptQueue
implements Listener {
    protected static int totalQueues = 0;
    public static Map<String, ScriptQueue> _queues = new ConcurrentHashMap<String, ScriptQueue>();
    public String id;
    protected int taskId;
    protected int ticks;
    List<ScriptEntry> scriptEntries = new ArrayList<ScriptEntry>();
    protected long delayTime = 0L;
    protected long delayTicks = 0L;
    protected Map<String, String> context = new ConcurrentHashMap<String, String>();
    protected ScriptEntry lastEntryExecuted = null;
    protected boolean paused = false;
    private boolean isStarted = false;

    public String toString() {
        return this.id;
    }

    public static String _getStats() {
        return "Total number of queues created: '" + totalQueues + "', currently active queues: '" + _queues.size() + "'.";
    }

    public static String _getNextId() {
        return UUID.randomUUID().toString();
    }

    public static Collection<ScriptQueue> _getQueues() {
        return _queues.values();
    }

    public static ScriptQueue _getQueue(String id) {
        if (id == null) {
            id = String.valueOf(ScriptQueue._getNextId());
        }
        ScriptQueue scriptQueue = ScriptQueue._queueExists(id) ? _queues.get(id.toUpperCase()) : new ScriptQueue(id, Settings.InteractDelayInTicks());
        return scriptQueue;
    }

    public static ScriptQueue _getInstantQueue(String id) {
        if (id == null) {
            id = String.valueOf(ScriptQueue._getNextId());
        }
        ScriptQueue scriptQueue = ScriptQueue._queueExists(id) ? _queues.get(id.toUpperCase()) : new ScriptQueue(id, 0);
        return scriptQueue;
    }

    public static boolean _queueExists(String id) {
        return _queues.containsKey(id.toUpperCase());
    }

    public void setLastEntryExecuted(ScriptEntry entry) {
        this.lastEntryExecuted = entry;
    }

    public Duration getSpeed() {
        return Duration.valueOf(this.ticks + "t");
    }

    public ScriptEntry getLastEntryExecuted() {
        return this.lastEntryExecuted;
    }

    public void clear() {
        this.scriptEntries.clear();
    }

    protected ScriptQueue(String id, int ticks) {
        this.id = id.toUpperCase();
        _queues.put(id.toUpperCase(), this);
        ++totalQueues;
        this.ticks = ticks;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setSpeed(int ticks) {
        this.ticks = ticks;
    }

    public void delayFor(long delayTicks) {
        this.delayTicks = delayTicks;
    }

    public void delayUntil(long delayTime) {
        this.delayTime = delayTime;
    }

    public void stop() {
        _queues.remove(this.id);
        dB.echoDebug("Completing queue " + this.id + "...");
        Bukkit.getServer().getScheduler().cancelTask(this.taskId);
    }

    public void start() {
        if (this.isStarted) {
            return;
        }
        dB.log("Starting " + this.id + "... (Speed=" + this.ticks + "tpr)");
        this.isStarted = true;
        if (this.ticks > 0) {
            this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    ScriptQueue.this.revolve();
                }
            }, (long)this.ticks, (long)this.ticks);
        } else if (this.delayTime > System.currentTimeMillis()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    while (ScriptQueue.this.isStarted) {
                        ScriptQueue.this.revolve();
                    }
                }
            }, this.delayTicks + 1L);
        } else {
            while (this.isStarted) {
                this.revolve();
            }
        }
    }

    private void revolve() {
        if (this.scriptEntries.isEmpty()) {
            this.stop();
            this.isStarted = false;
            return;
        }
        if (this.paused) {
            return;
        }
        if (this.delayTime > System.currentTimeMillis()) {
            return;
        }
        DenizenAPI.getCurrentInstance().getScriptEngine().revolve(this);
    }

    public ScriptEntry getNext() {
        if (!this.scriptEntries.isEmpty()) {
            ScriptEntry entry = this.scriptEntries.get(0);
            this.scriptEntries.remove(0);
            return entry;
        }
        return null;
    }

    public ScriptQueue addEntries(List<ScriptEntry> entries) {
        this.scriptEntries.addAll(entries);
        return this;
    }

    public ScriptQueue injectEntries(List<ScriptEntry> entries, int position) {
        if (position > this.scriptEntries.size() || position < 0) {
            position = 1;
        }
        if (this.scriptEntries.size() == 0) {
            position = 0;
        }
        this.scriptEntries.addAll(position, entries);
        return this;
    }

    public boolean removeEntry(int position) {
        if (this.scriptEntries.size() < position) {
            return false;
        }
        this.scriptEntries.remove(position);
        return true;
    }

    public ScriptEntry getEntry(int position) {
        if (this.scriptEntries.size() < position) {
            return null;
        }
        return this.scriptEntries.get(position);
    }

    public ScriptQueue injectEntry(ScriptEntry entry, int position) {
        if (position > this.scriptEntries.size() || position < 0) {
            position = 1;
        }
        if (this.scriptEntries.size() == 0) {
            position = 0;
        }
        this.scriptEntries.add(position, entry);
        return this;
    }

    public int getQueueSize() {
        return this.scriptEntries.size();
    }
}

