/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.interfaces.DenizenRegistry;
import net.aufdemrand.denizen.interfaces.RegistrationableInstance;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.commands.core.AnchorCommand;
import net.aufdemrand.denizen.scripts.commands.core.AnnounceCommand;
import net.aufdemrand.denizen.scripts.commands.core.AssignmentCommand;
import net.aufdemrand.denizen.scripts.commands.core.AttackCommand;
import net.aufdemrand.denizen.scripts.commands.core.CastCommand;
import net.aufdemrand.denizen.scripts.commands.core.ChatCommand;
import net.aufdemrand.denizen.scripts.commands.core.ClearCommand;
import net.aufdemrand.denizen.scripts.commands.core.CooldownCommand;
import net.aufdemrand.denizen.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizen.scripts.commands.core.DisengageCommand;
import net.aufdemrand.denizen.scripts.commands.core.DisplayItemCommand;
import net.aufdemrand.denizen.scripts.commands.core.DropCommand;
import net.aufdemrand.denizen.scripts.commands.core.EngageCommand;
import net.aufdemrand.denizen.scripts.commands.core.ExecuteCommand;
import net.aufdemrand.denizen.scripts.commands.core.FailCommand;
import net.aufdemrand.denizen.scripts.commands.core.FeedCommand;
import net.aufdemrand.denizen.scripts.commands.core.FinishCommand;
import net.aufdemrand.denizen.scripts.commands.core.FlagCommand;
import net.aufdemrand.denizen.scripts.commands.core.FollowCommand;
import net.aufdemrand.denizen.scripts.commands.core.GiveCommand;
import net.aufdemrand.denizen.scripts.commands.core.HealCommand;
import net.aufdemrand.denizen.scripts.commands.core.IfCommand;
import net.aufdemrand.denizen.scripts.commands.core.ListenCommand;
import net.aufdemrand.denizen.scripts.commands.core.LookCommand;
import net.aufdemrand.denizen.scripts.commands.core.LookcloseCommand;
import net.aufdemrand.denizen.scripts.commands.core.ModifyBlockCommand;
import net.aufdemrand.denizen.scripts.commands.core.NameplateCommand;
import net.aufdemrand.denizen.scripts.commands.core.NarrateCommand;
import net.aufdemrand.denizen.scripts.commands.core.NewCommand;
import net.aufdemrand.denizen.scripts.commands.core.PlaySoundCommand;
import net.aufdemrand.denizen.scripts.commands.core.PoseCommand;
import net.aufdemrand.denizen.scripts.commands.core.QueueCommand;
import net.aufdemrand.denizen.scripts.commands.core.RandomCommand;
import net.aufdemrand.denizen.scripts.commands.core.RuntaskCommand;
import net.aufdemrand.denizen.scripts.commands.core.ScribeCommand;
import net.aufdemrand.denizen.scripts.commands.core.ShootCommand;
import net.aufdemrand.denizen.scripts.commands.core.SitCommand;
import net.aufdemrand.denizen.scripts.commands.core.StandCommand;
import net.aufdemrand.denizen.scripts.commands.core.StrikeCommand;
import net.aufdemrand.denizen.scripts.commands.core.SwitchCommand;
import net.aufdemrand.denizen.scripts.commands.core.TakeCommand;
import net.aufdemrand.denizen.scripts.commands.core.TeleportCommand;
import net.aufdemrand.denizen.scripts.commands.core.TriggerCommand;
import net.aufdemrand.denizen.scripts.commands.core.VulnerableCommand;
import net.aufdemrand.denizen.scripts.commands.core.WaitCommand;
import net.aufdemrand.denizen.scripts.commands.core.WalkToCommand;
import net.aufdemrand.denizen.scripts.commands.core.ZapCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRegistry
implements DenizenRegistry {
    public Denizen denizen;
    private Map<String, AbstractCommand> instances = new HashMap<String, AbstractCommand>();
    private Map<Class<? extends AbstractCommand>, String> classes = new HashMap<Class<? extends AbstractCommand>, String>();

    public CommandRegistry(Denizen denizen) {
        this.denizen = denizen;
    }

    @Override
    public boolean register(String commandName, RegistrationableInstance commandInstance) {
        this.instances.put(commandName.toUpperCase(), (AbstractCommand)commandInstance);
        this.classes.put(((AbstractCommand)commandInstance).getClass(), commandName.toUpperCase());
        return true;
    }

    public Map<String, AbstractCommand> list() {
        return this.instances;
    }

    @Override
    public AbstractCommand get(String commandName) {
        if (this.instances.containsKey(commandName.toUpperCase())) {
            return this.instances.get(commandName.toUpperCase());
        }
        return null;
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        if (this.classes.containsKey(clazz)) {
            return (T)((RegistrationableInstance)clazz.cast(this.instances.get(this.classes.get(clazz))));
        }
        return null;
    }

    @Override
    public void registerCoreMembers() {
        this.registerCoreMember(AnnounceCommand.class, "ANNOUNCE", "announce [\"announcement text\"] (to_ops)", 1);
        this.registerCoreMember(AttackCommand.class, "ATTACK", "attack (stop)", 0);
        this.registerCoreMember(AnchorCommand.class, "ANCHOR", "anchor [id:name] [assume|add|remove|walkto|walknear] (range:#)", 2);
        this.registerCoreMember(AssignmentCommand.class, "ASSIGNMENT", "assignment [{set}|remove] (script:assignment_script)", 1);
        this.registerCoreMember(CastCommand.class, "CAST", "cast [effect] (duration:#{60s}) (power:#{1}) (target(s):npc|player|npc.#|player.player_name|entity_name)", 1);
        this.registerCoreMember(ChatCommand.class, "CHAT", "chat [\"chat text\"] (npcid:#) (target(s):npc.#|player.name{attached player})", 1);
        this.registerCoreMember(ClearCommand.class, "CLEAR", "clear (queue:name) (...)", 1);
        this.registerCoreMember(CooldownCommand.class, "COOLDOWN", "cooldown (duration:#{60s}) (global|player:name{attached player}) (script:name)", 1);
        this.registerCoreMember(DetermineCommand.class, "DETERMINE", "determine [\"value\"]", 1);
        this.registerCoreMember(DisengageCommand.class, "DISENGAGE", "disengage (npcid:#)", 0);
        this.registerCoreMember(DisplayItemCommand.class, "DISPLAYITEM", "displayitem [item_name|remove] [location:x,y,z,world] (duration:#)", 2);
        this.registerCoreMember(DropCommand.class, "DROP", "drop [item:#(:#)|item:material(:#)|xp] (qty:#{1}) (location:x,y,z,world)", 1);
        this.registerCoreMember(EngageCommand.class, "ENGAGE", "engage (duration:#) (npcid:#)", 0);
        this.registerCoreMember(ExecuteCommand.class, "EXECUTE", "execute [as_player|as_op|as_npc|as_server] [\"Bukkit command\"]", 2);
        this.registerCoreMember(FailCommand.class, "FAIL", "fail (script:name{attached script}) (player:player_name)", 0);
        this.registerCoreMember(FeedCommand.class, "FEED", "feed (amt:#) (target:npc|{player})", 0);
        this.registerCoreMember(FinishCommand.class, "FINISH", "finish (script:name{attached script}) (player:player_name)", 0);
        this.registerCoreMember(FlagCommand.class, "FLAG", "flag ({player}|npc|global) [name([#])](:action)[:value] (duration:#)", 1);
        this.registerCoreMember(FollowCommand.class, "FOLLOW", "follow (stop)", 0);
        this.registerCoreMember(GiveCommand.class, "GIVE", "give [money|item:#(:#)|item:material(:#)] (qty:#)", 1);
        this.registerCoreMember(HealCommand.class, "HEAL", "heal (amt:#) (target:npc|{player})", 0);
        this.registerCoreMember(IfCommand.class, "IF", "if [comparable] (!)(operator) (compared_to) (bridge) (...) [command] (else) (command)  +--> see documentation.", 2);
        this.registerCoreMember(ListenCommand.class, "LISTEN", "listen [listener_type] [id:listener_id] (...)  +--> see documentation - http://bit.ly/XJlKwm", 2);
        this.registerCoreMember(LookCommand.class, "LOOK", "look [location:x,y,z,world]", 1);
        this.registerCoreMember(LookcloseCommand.class, "LOOKCLOSE", "lookclose [toggle:true|false]", 1);
        this.registerCoreMember(ModifyBlockCommand.class, "MODIFYBLOCK", "modifyblock [location:x,y,z,world] [material:data] (radius:#) (height:#) (depth:#)", 2);
        this.registerCoreMember(NameplateCommand.class, "NAMEPLATE", "nameplate [chat_color] (target:player_name)", 1);
        this.registerCoreMember(NarrateCommand.class, "NARRATE", "narrate [\"narration text\"] (player:name)", 1);
        this.registerCoreMember(NewCommand.class, "NEW", "new itemstack [item:material] (qty:#)", 2);
        this.registerCoreMember(PoseCommand.class, "POSE", "pose [id:name]", 1);
        this.registerCoreMember(PlaySoundCommand.class, "PLAYSOUND", "playsound [location:x,y,z,world] [sound:name] (volume:#) (pitch:#)", 2);
        this.registerCoreMember(QueueCommand.class, "QUEUE", "queue (queue:id{residing_queue}) [clear|pause|resume|delay:#]", 1);
        this.registerCoreMember(RandomCommand.class, "RANDOM", "random [#]", 1);
        this.registerCoreMember(RuntaskCommand.class, "RUNTASK", "runtask [script_name] (instantly) (queue|queue:queue_name) (delay:#)", 1);
        this.registerCoreMember(ScribeCommand.class, "SCRIBE", "scribe [script:book_script] (give|{drop}|equip) (location:x,y,z,world) OR scribe [item:id.name] [script:book_script]", 1);
        this.registerCoreMember(ShootCommand.class, "SHOOT", "shoot [entity:name] (ride) (burn) (explode) (location:x,y,z,world) (script:name)", 1);
        this.registerCoreMember(SitCommand.class, "SIT", "sit (location:x,y,z,world)", 0);
        this.registerCoreMember(StandCommand.class, "STAND", "stand", 0);
        this.registerCoreMember(StrikeCommand.class, "STRIKE", "strike (no_damage) [location:x,y,z,world]", 1);
        this.registerCoreMember(SwitchCommand.class, "SWITCH", "switch [location:x,y,z,world] (state:[{toggle}|on|off]) (duration:#)", 1);
        this.registerCoreMember(TakeCommand.class, "TAKE", "take [money|iteminhand|item:#(:#)|item:material(:#)] (qty:#)", 1);
        this.registerCoreMember(TeleportCommand.class, "TELEPORT", "teleport (npc) [location:x,y,z,world] (target(s):[npc.#]|[player.name])", 1);
        this.registerCoreMember(TriggerCommand.class, "TRIGGER", "trigger [name:trigger_name] [(toggle:true|false)|(cooldown:#.#)|(radius:#)]", 2);
        this.registerCoreMember(VulnerableCommand.class, "VULNERABLE", "vulnerable (toggle:{true}|false|toggle)", 0);
        this.registerCoreMember(WaitCommand.class, "WAIT", "wait (duration:#{5s}) (queue:queue_type) (player:player_name{attached}) (npcid:#{attached})", 0);
        this.registerCoreMember(WalkToCommand.class, "WALKTO", "walkto [location:x,y,z,world] (speed:#)", 1);
        this.registerCoreMember(ZapCommand.class, "ZAP", "zap [#|step:step_name] (script:script_name{current_script}) (duration:#)", 0);
        dB.echoApproval("Loaded core commands: " + this.instances.keySet().toString());
    }

    private <T extends AbstractCommand> void registerCoreMember(Class<T> cmd, String name, String hint, int args) {
        block2: {
            try {
                ((AbstractCommand)cmd.newInstance()).activate().as(name).withOptions(hint, args);
            }
            catch (Exception e) {
                dB.echoError("Could not register command " + name + ": " + e.getMessage());
                if (!dB.showStackTraces) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void disableCoreMembers() {
        for (AbstractCommand member : this.instances.values()) {
            try {
                member.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + member.getClass().getName() + "'!");
                if (!dB.showStackTraces) continue;
                e.printStackTrace();
            }
        }
    }
}

